/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class SlabEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        if (adjState.func_177230_c() == FBContent.blockFramedSlabEdge.get()) {
            return this.testAgainstEdge(world, pos, dir, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlab.get()) {
            return this.testAgainstSlab(world, pos, dir, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedDoubleSlab.get()) {
            return this.testAgainstDoubleSlab(world, pos, dir, top, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlabCorner.get()) {
            return this.testAgainstCorner(world, pos, dir, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedPanel.get()) {
            return this.testAgainstPanel(world, pos, dir, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedDoublePanel.get()) {
            return this.testAgainstDoublePanel(world, pos, dir, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedStairs.get()) {
            return this.testAgainstStairs(world, pos, dir, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedVerticalStairs.get()) {
            return this.testAgainstVerticalStairs(world, pos, dir, top, adjState, side);
        }
        return false;
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir && adjDir == side.func_176734_d()) {
            return top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side == dir.func_176746_e() || side == dir.func_176735_f()) {
            return dir == adjDir && top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        if (side.func_176740_k() == Direction.Axis.Y && dir == adjDir) {
            return top != adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir || top != (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side);
    }

    private boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, Direction dir, boolean top, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(world, pos, side, face);
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
            return top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side.func_176740_k() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side.func_176740_k() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        if (dir != adjDir && dir != adjDir.func_176734_d()) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            if (adjShape != StairsShape.STRAIGHT || dir != adjDir) {
                return false;
            }
            return top == adjTop && SideSkipPredicate.compareState(world, pos, side);
        }
        if (top == adjTop && side == dir && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL) {
            return false;
        }
        if (side == dir.func_176735_f() && adjDir == dir || side == dir.func_176746_e() && adjDir == dir.func_176746_e()) {
            return top != adjType.isTop() && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

