/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class StairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        boolean top;
        if (SideSkipPredicate.CTM.test(world, pos, state, adjState, side)) {
            return true;
        }
        Direction dir = (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a);
        StairsShape shape = (StairsShape)state.func_177229_b((Property)StairsBlock.field_176310_M);
        boolean bl = top = state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
        if (adjState.func_177230_c() == FBContent.blockFramedStairs.get()) {
            return this.testAgainstStairs(world, pos, dir, shape, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlab.get()) {
            return this.testAgainstSlab(world, pos, dir, shape, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedDoubleSlab.get()) {
            return this.testAgainstDoubleSlab(world, pos, dir, shape, top, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlabEdge.get()) {
            return this.testAgainstEdge(world, pos, dir, shape, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedPanel.get()) {
            return this.testAgainstPanel(world, pos, dir, shape, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedDoublePanel.get()) {
            return this.testAgainstDoublePanel(world, pos, dir, shape, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedCornerPillar.get()) {
            return this.testAgainstPillar(world, pos, dir, shape, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedSlabCorner.get()) {
            return this.testAgainstCorner(world, pos, dir, shape, top, adjState, side);
        }
        if (adjState.func_177230_c() == FBContent.blockFramedVerticalStairs.get()) {
            return this.testAgainstVerticalStairs(world, pos, dir, shape, top, adjState, side);
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)StairsBlock.field_176309_a);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)StairsBlock.field_176310_M);
        if (StairsSkipPredicate.isStairSide(shape, dir, side) && StairsSkipPredicate.isStairSide(adjShape, adjDir, side.func_176734_d()) || StairsSkipPredicate.isSlabSide(shape, dir, side) && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.func_176734_d())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstSlab(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (top != adjTop) {
            return false;
        }
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side);
    }

    private boolean testAgainstDoubleSlab(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(world, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (top != adjTop) {
            return false;
        }
        if (adjDir == side.func_176734_d()) {
            if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
                return false;
            }
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (top && side == Direction.DOWN || !top && side == Direction.UP) {
            if (shape != StairsShape.STRAIGHT) {
                return false;
            }
            return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        return dir == adjDir && SideSkipPredicate.compareState(world, pos, side);
    }

    private boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        if (dir == adjDir || dir.func_176734_d() == adjDir) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstPillar(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (shape == StairsShape.OUTER_LEFT && dir == adjDir || shape == StairsShape.OUTER_RIGHT && dir.func_176746_e() == adjDir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstCorner(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (shape == StairsShape.OUTER_LEFT && dir == adjDir || shape == StairsShape.OUTER_RIGHT && dir.func_176746_e() == adjDir) {
            return adjTop == top && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL ? (side == Direction.DOWN && top || side == Direction.UP && !top) && (shape == StairsShape.INNER_LEFT && adjDir == dir || shape == StairsShape.INNER_RIGHT && adjDir == dir.func_176746_e()) : adjType.isTop() != top && (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176735_f() && adjDir == dir.func_176746_e())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    public static boolean isStairSide(StairsShape shape, Direction dir, Direction side) {
        if (shape == StairsShape.STRAIGHT) {
            return side == dir.func_176746_e() || side == dir.func_176735_f();
        }
        if (shape == StairsShape.INNER_LEFT) {
            return side == dir.func_176734_d() || side == dir.func_176746_e();
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return side == dir.func_176734_d() || side == dir.func_176735_f();
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return side == dir || side == dir.func_176735_f();
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return side == dir || side == dir.func_176746_e();
        }
        return false;
    }

    public static boolean isSlabSide(StairsShape shape, Direction dir, Direction side) {
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT) {
            return false;
        }
        if (shape == StairsShape.STRAIGHT) {
            return side == dir.func_176734_d();
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return side == dir.func_176734_d() || side == dir.func_176746_e();
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return side == dir.func_176734_d() || side == dir.func_176735_f();
        }
        return false;
    }
}

