/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.container.FramedChestContainer;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedTileEntity;

public class FramedChestTileEntity
extends FramedTileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    public static final ITextComponent TITLE = new TranslationTextComponent("title.framedblocks:framed_chest");
    private final ItemStackHandler itemHandler = new ItemStackHandler(36);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private int openCount = 0;
    private long closeStart = 0L;
    private long lastChangeTime = 0L;
    private ChestState lastState = ChestState.CLOSED;

    public FramedChestTileEntity() {
        super((TileEntityType)FBContent.tileTypeFramedChest.get());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d() && this.field_145850_b.func_82737_E() - this.closeStart >= 10L && this.func_195044_w().func_177229_b(PropertyHolder.CHEST_STATE) == ChestState.CLOSING) {
            this.closeStart = 0L;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSED)));
        }
    }

    public void open() {
        ++this.openCount;
    }

    public void close() {
        if (this.openCount > 0) {
            --this.openCount;
            if (this.openCount == 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSING)));
                this.closeStart = this.field_145850_b.func_82737_E();
            }
        }
    }

    public long getLastChangeTime(ChestState state) {
        if (this.lastChangeTime == 0L || state != this.lastState) {
            if (this.lastState == ChestState.CLOSING && state == ChestState.OPENING || this.lastState == ChestState.OPENING && state == ChestState.CLOSING) {
                long diff = this.field_145850_b.func_82737_E() - this.lastChangeTime;
                this.lastChangeTime = this.field_145850_b.func_82737_E() - (diff < 10L ? 10L - diff : 0L);
            } else {
                this.lastChangeTime = this.field_145850_b.func_82737_E();
            }
            this.lastState = state;
        }
        return this.lastChangeTime;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void addDrops(List<ItemStack> drops) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
    }

    @Override
    public CompoundNBT writeToBlueprint() {
        return super.func_189515_b(new CompoundNBT());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("inventory", (INBT)this.itemHandler.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    public ITextComponent func_145748_c_() {
        return TITLE;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new FramedChestContainer(windowId, inv, this);
    }
}

