/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class Utils {
    public static final ITag.INamedTag<Block> FRAMEABLE = BlockTags.func_199894_a((String)"framedblocks:frameable");
    public static final ITag.INamedTag<Block> BLACKLIST = BlockTags.func_199894_a((String)"framedblocks:blacklisted");
    public static final ITag.INamedTag<Item> WRENCH = ItemTags.func_199901_a((String)"forge:tools/wrench");

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from.func_176740_k() == Direction.Axis.Y || to.func_176740_k() == Direction.Axis.Y) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - from.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        return buffer[0];
    }

    public static Vector3d fraction(Vector3d vec) {
        return new Vector3d(vec.func_82615_a() - Math.floor(vec.func_82615_a()), vec.func_82617_b() - Math.floor(vec.func_82617_b()), vec.func_82616_c() - Math.floor(vec.func_82616_c()));
    }

    public static void enqueueImmediateTask(IWorld world, Runnable task, boolean allowClient) {
        if (world.func_201670_d() && allowClient) {
            task.run();
        } else {
            Utils.enqueueTask(world, task, 0);
        }
    }

    public static void enqueueTask(IWorld world, Runnable task, int delay) {
        if (!(world instanceof ServerWorld)) {
            throw new IllegalArgumentException("Utils#enqueueTask() called with a non-ServerWorld");
        }
        MinecraftServer server = ((ServerWorld)world).func_73046_m();
        server.func_212871_a_((Runnable)new TickDelayedTask(server.func_71259_af() + delay, task));
    }
}

