/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fmllegacy.RegistryObject;
import xfacthd.framedblocks.client.model.FramedBarsModel;
import xfacthd.framedblocks.client.model.FramedButtonModel;
import xfacthd.framedblocks.client.model.FramedChestModel;
import xfacthd.framedblocks.client.model.FramedCornerPillarModel;
import xfacthd.framedblocks.client.model.FramedCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedCubeModel;
import xfacthd.framedblocks.client.model.FramedDoorModel;
import xfacthd.framedblocks.client.model.FramedDoubleCornerModel;
import xfacthd.framedblocks.client.model.FramedDoublePanelModel;
import xfacthd.framedblocks.client.model.FramedDoublePrismCornerModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlabModel;
import xfacthd.framedblocks.client.model.FramedDoubleSlopeModel;
import xfacthd.framedblocks.client.model.FramedDoubleThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedFenceGateModel;
import xfacthd.framedblocks.client.model.FramedFenceModel;
import xfacthd.framedblocks.client.model.FramedFloorModel;
import xfacthd.framedblocks.client.model.FramedInnerCornerSlopeModel;
import xfacthd.framedblocks.client.model.FramedInnerPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedInnerThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedLadderModel;
import xfacthd.framedblocks.client.model.FramedLatticeModel;
import xfacthd.framedblocks.client.model.FramedLeverModel;
import xfacthd.framedblocks.client.model.FramedPaneModel;
import xfacthd.framedblocks.client.model.FramedPanelModel;
import xfacthd.framedblocks.client.model.FramedPressurePlateModel;
import xfacthd.framedblocks.client.model.FramedPrismCornerModel;
import xfacthd.framedblocks.client.model.FramedSignModel;
import xfacthd.framedblocks.client.model.FramedSlabCornerModel;
import xfacthd.framedblocks.client.model.FramedSlabEdgeModel;
import xfacthd.framedblocks.client.model.FramedSlabModel;
import xfacthd.framedblocks.client.model.FramedSlopeModel;
import xfacthd.framedblocks.client.model.FramedSoulTorchModel;
import xfacthd.framedblocks.client.model.FramedSoulWallTorchModel;
import xfacthd.framedblocks.client.model.FramedStairsModel;
import xfacthd.framedblocks.client.model.FramedThreewayCornerModel;
import xfacthd.framedblocks.client.model.FramedTorchModel;
import xfacthd.framedblocks.client.model.FramedTrapDoorModel;
import xfacthd.framedblocks.client.model.FramedVerticalStairsModel;
import xfacthd.framedblocks.client.model.FramedWallModel;
import xfacthd.framedblocks.client.model.FramedWallSignModel;
import xfacthd.framedblocks.client.model.FramedWallTorchModel;
import xfacthd.framedblocks.client.render.FramedChestRenderer;
import xfacthd.framedblocks.client.render.FramedSignRenderer;
import xfacthd.framedblocks.client.screen.FramedChestScreen;
import xfacthd.framedblocks.client.screen.FramedSignScreen;
import xfacthd.framedblocks.client.util.BlueprintPropertyOverride;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedSignBlockEntity;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class FBClient {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, type -> type == RenderType.m_110451_() || type == RenderType.m_110463_() || type == RenderType.m_110457_() || type == RenderType.m_110466_()));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)FBContent.blockEntityTypeFramedSign.get()), FramedSignRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)FBContent.blockEntityTypeFramedChest.get()), FramedChestRenderer::new);
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)FBContent.menuTypeFramedChest.get()), FramedChestScreen::new);
            BlueprintPropertyOverride.register();
        });
    }

    @SubscribeEvent
    public static void onBlockColors(ColorHandlerEvent.Block event) {
        Block[] blocks = (Block[])FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).toArray(Block[]::new);
        event.getBlockColors().m_92589_((state, world, pos, tintIndex) -> {
            FramedBlockEntity fbe;
            BlockEntity fbe$temp;
            BlockState camoState;
            if (world == null || pos == null) return -1;
            BlockEntity be = world.m_7702_(pos);
            BlockEntity dbe$temp = be;
            if (dbe$temp instanceof FramedDoubleBlockEntity) {
                FramedDoubleBlockEntity dbe = (FramedDoubleBlockEntity)dbe$temp;
                if (tintIndex < -1) {
                    tintIndex = ModelUtils.decodeSecondaryTintIndex(tintIndex);
                    camoState = dbe.getCamoStateTwo();
                    if (camoState.m_60795_()) return -1;
                    return event.getBlockColors().m_92577_(camoState, world, pos, tintIndex);
                }
            }
            if (!((fbe$temp = be) instanceof FramedBlockEntity) || (camoState = (fbe = (FramedBlockEntity)fbe$temp).getCamoState()).m_60795_()) return -1;
            return event.getBlockColors().m_92577_(camoState, world, pos, tintIndex);
        }, blocks);
    }

    @SubscribeEvent
    public static void onModelsLoaded(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        FramedChestRenderer.onModelsLoaded(registry);
        FBClient.replaceModels(FBContent.blockFramedCube, registry, FramedCubeModel::new);
        FBClient.replaceModels(FBContent.blockFramedSlope, registry, FramedSlopeModel::new, FramedSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedCornerSlope, registry, FramedCornerSlopeModel::new, FramedCornerSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedInnerCornerSlope, registry, FramedInnerCornerSlopeModel::new, FramedInnerCornerSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedPrismCorner, registry, FramedPrismCornerModel::new, FramedPrismCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedInnerPrismCorner, registry, FramedInnerPrismCornerModel::new, FramedInnerPrismCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedThreewayCorner, registry, FramedThreewayCornerModel::new, FramedThreewayCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedInnerThreewayCorner, registry, FramedInnerThreewayCornerModel::new, FramedInnerThreewayCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedSlab, registry, FramedSlabModel::new);
        FBClient.replaceModels(FBContent.blockFramedSlabEdge, registry, FramedSlabEdgeModel::new);
        FBClient.replaceModels(FBContent.blockFramedSlabCorner, registry, FramedSlabCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedPanel, registry, FramedPanelModel::new);
        FBClient.replaceModels(FBContent.blockFramedCornerPillar, registry, FramedCornerPillarModel::new);
        FBClient.replaceModels(FBContent.blockFramedStairs, registry, FramedStairsModel::new);
        FBClient.replaceModels(FBContent.blockFramedWall, registry, FramedWallModel::new);
        FBClient.replaceModels(FBContent.blockFramedFence, registry, FramedFenceModel::createFenceModel);
        FBClient.replaceModels(FBContent.blockFramedGate, registry, FramedFenceGateModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoor, registry, FramedDoorModel::new);
        FBClient.replaceModels(FBContent.blockFramedTrapDoor, registry, FramedTrapDoorModel::new);
        FBClient.replaceModels(FBContent.blockFramedPressurePlate, registry, FramedPressurePlateModel::new);
        FBClient.replaceModels(FBContent.blockFramedLadder, registry, FramedLadderModel::new, FramedLadderModel::new);
        FBClient.replaceModels(FBContent.blockFramedButton, registry, FramedButtonModel::new);
        FBClient.replaceModels(FBContent.blockFramedLever, registry, FramedLeverModel::new);
        FBClient.replaceModels(FBContent.blockFramedSign, registry, FramedSignModel::new);
        FBClient.replaceModels(FBContent.blockFramedWallSign, registry, FramedWallSignModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoubleSlab, registry, FramedDoubleSlabModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoublePanel, registry, FramedDoublePanelModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoubleSlope, registry, FramedDoubleSlopeModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoubleCorner, registry, FramedDoubleCornerModel::new, FramedDoubleCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoublePrismCorner, registry, FramedDoublePrismCornerModel::new, FramedDoublePrismCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedDoubleThreewayCorner, registry, FramedDoubleThreewayCornerModel::new, FramedDoubleThreewayCornerModel::new);
        FBClient.replaceModels(FBContent.blockFramedTorch, registry, FramedTorchModel::new);
        FBClient.replaceModels(FBContent.blockFramedWallTorch, registry, FramedWallTorchModel::new);
        FBClient.replaceModels(FBContent.blockFramedSoulTorch, registry, FramedSoulTorchModel::new);
        FBClient.replaceModels(FBContent.blockFramedSoulWallTorch, registry, FramedSoulWallTorchModel::new);
        FBClient.replaceModels(FBContent.blockFramedFloor, registry, FramedFloorModel::new);
        FBClient.replaceModels(FBContent.blockFramedLattice, registry, FramedLatticeModel::new);
        FBClient.replaceModels(FBContent.blockFramedVerticalStairs, registry, FramedVerticalStairsModel::new);
        FBClient.replaceModels(FBContent.blockFramedChest, registry, FramedChestModel::new, FramedChestModel::new);
        FBClient.replaceModels(FBContent.blockFramedBars, registry, FramedBarsModel::new);
        FBClient.replaceModels(FBContent.blockFramedPane, registry, FramedPaneModel::new);
    }

    private static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen) {
        FBClient.replaceModels(block, models, blockModelGen, model -> model);
    }

    private static void replaceModels(RegistryObject<Block> block, Map<ResourceLocation, BakedModel> models, BiFunction<BlockState, BakedModel, BakedModel> blockModelGen, Function<BakedModel, BakedModel> itemModelGen) {
        for (BlockState state : ((Block)block.get()).m_49965_().m_61056_()) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
            BakedModel baseModel = models.get(location);
            BakedModel replacement = blockModelGen.apply(state, baseModel);
            models.put((ResourceLocation)location, replacement);
        }
        ModelResourceLocation location = new ModelResourceLocation(((Block)block.get()).getRegistryName(), "inventory");
        BakedModel replacement = itemModelGen.apply(models.get(location));
        models.put((ResourceLocation)location, replacement);
    }

    public static void openSignScreen(BlockPos pos) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity be = (FramedSignBlockEntity)blockEntity;
            Minecraft.m_91087_().m_91152_((Screen)new FramedSignScreen(be));
        }
    }
}

