/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.client.model.FramedPaneModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedBarsModel
extends FramedPaneModel {
    public FramedBarsModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        if (face.m_122434_() == Direction.Axis.Y) {
            this.createTopBottomCenterQuad(quadMap, quad, false);
            this.createTopBottomCenterQuad(quadMap, quad, true);
            if (this.north) {
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, false);
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, true);
            }
            if (this.east) {
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.EAST, false);
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.EAST, true);
            }
            if (this.south) {
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, false);
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, true);
            }
            if (this.west) {
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.WEST, false);
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.WEST, true);
            }
        } else {
            if (!this.isSideInset(face)) {
                this.createSideEdgeQuad(quadMap, quad, false, false);
            }
            if (!this.isSideInset(face.m_122424_())) {
                this.createSideEdgeQuad(quadMap, quad, false, true);
            }
            if (face.m_122434_() == Direction.Axis.X) {
                this.createCenterPillarQuad(quadMap.get(null), quad, this.east, this.west, this.south, this.north);
                if (this.north) {
                    this.createPillarQuad(quadMap.get(null), quad, Direction.NORTH);
                    this.createBarQuads(quadMap.get(null), quad, Direction.NORTH);
                }
                if (this.south) {
                    this.createPillarQuad(quadMap.get(null), quad, Direction.SOUTH);
                    this.createBarQuads(quadMap.get(null), quad, Direction.SOUTH);
                }
            }
            if (face.m_122434_() == Direction.Axis.Z) {
                this.createCenterPillarQuad(quadMap.get(null), quad, this.south, this.north, this.east, this.west);
                if (this.east) {
                    this.createPillarQuad(quadMap.get(null), quad, Direction.EAST);
                    this.createBarQuads(quadMap.get(null), quad, Direction.EAST);
                }
                if (this.west) {
                    this.createPillarQuad(quadMap.get(null), quad, Direction.WEST);
                    this.createBarQuads(quadMap.get(null), quad, Direction.WEST);
                }
            }
        }
    }

    private void createCenterPillarQuad(List<BakedQuad> quadList, BakedQuad quad, boolean perpNeg, boolean perpPos, boolean parNeg, boolean parPos) {
        float offset;
        float maxXZ;
        if (perpNeg && perpPos && !parNeg && !parPos) {
            return;
        }
        boolean perpendicular = perpNeg || perpPos;
        boolean oneParallel = parNeg ^ parPos;
        float minXZ = perpendicular && oneParallel && !parPos ? 0.5f : 0.4375f;
        float f = maxXZ = perpendicular && oneParallel && !parNeg ? 0.5f : 0.5625f;
        if (parNeg || parPos) {
            offset = 0.5f;
        } else {
            float f2 = perpNeg ? 0.5625f : (offset = perpPos ? 0.4375f : 0.5f);
            if (quad.m_111306_().m_122421_() == Direction.AxisDirection.POSITIVE) {
                offset = 1.0f - offset;
            }
        }
        BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.0f, maxXZ, 1.0f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, offset);
            quadList.add(sideQuad);
        }
    }

    private void createPillarQuad(List<BakedQuad> quadList, BakedQuad quad, Direction dir) {
        if (dir.m_122434_() == Direction.Axis.Y) {
            throw new IllegalArgumentException(String.format("Invalid direction: %s!", dir));
        }
        boolean positive = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
        float minXZ = positive ? 0.75f : 0.125f;
        float maxXZ = positive ? 0.875f : 0.25f;
        BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.0f, maxXZ, 1.0f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5f);
            quadList.add(sideQuad);
        }
    }

    private void createBarQuads(List<BakedQuad> quadList, BakedQuad quad, Direction dir) {
        if (dir.m_122434_() == Direction.Axis.Y) {
            throw new IllegalArgumentException(String.format("Invalid direction: %s!", dir));
        }
        boolean positive = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean northeast = dir == Direction.NORTH || dir == Direction.EAST;
        float minXZ = positive ? 0.5625f : 0.25f;
        float maxXZ = positive ? 0.75f : 0.4375f;
        float minY = northeast ? 0.125f : 0.75f;
        float maxY = northeast ? 0.25f : 0.875f;
        BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, minY, maxXZ, maxY)) {
            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5f);
            quadList.add(sideQuad);
        }
        minXZ = positive ? 0.875f : 0.0f;
        maxXZ = positive ? 1.0f : 0.125f;
        sideQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.4375f, maxXZ, 0.5625f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5f);
            quadList.add(sideQuad);
        }
    }
}

