/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.client.model.BakedModelProxy;
import xfacthd.framedblocks.client.model.FluidDummyModel;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public abstract class FramedBlockModel
extends BakedModelProxy {
    private static final boolean FORCE_NODATA = true;
    private final Table<BlockState, RenderType, Map<Direction, List<BakedQuad>>> quadCacheTable = HashBasedTable.create();
    private final Map<BlockState, BakedModel> modelCache = new HashMap<BlockState, BakedModel>();
    private final BlockState state;
    private final BlockType type;
    private final Map<BlockState, FluidDummyModel> fluidModels = new HashMap<BlockState, FluidDummyModel>();

    public FramedBlockModel(BlockState state, BakedModel baseModel) {
        super(baseModel);
        this.state = state;
        this.type = ((IFramedBlock)state.m_60734_()).getBlockType();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        BlockState camoState = Blocks.f_50016_.m_49966_();
        IModelData iModelData = extraData;
        if (iModelData instanceof FramedBlockData) {
            FramedBlockData data = (FramedBlockData)iModelData;
            if (layer != null) {
                if (side != null && ((IFramedBlock)state.m_60734_()).isSideHidden((BlockGetter)data.getLevel(), data.getPos(), state, side)) {
                    return Collections.emptyList();
                }
                camoState = data.getCamoState();
                if (camoState != null && !camoState.m_60795_() && this.canRenderInLayer(camoState, layer)) {
                    return this.getCamoQuads(state, camoState, side, rand, extraData, layer);
                }
            }
        }
        if (layer == null) {
            layer = RenderType.m_110463_();
        }
        if ((camoState == null || camoState.m_60795_()) && layer == RenderType.m_110463_()) {
            return this.getCamoQuads(state, ((Block)FBContent.blockFramedCube.get()).m_49966_(), side, rand, extraData, layer);
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> m_6840_(BlockState state, Direction side, Random rand) {
        if (state == null) {
            state = this.state;
        }
        return this.getCamoQuads(state, ((Block)FBContent.blockFramedCube.get()).m_49966_(), side, rand, (IModelData)EmptyModelData.INSTANCE, RenderType.m_110463_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BakedQuad> getCamoQuads(BlockState state, BlockState camoState, Direction side, Random rand, IModelData extraData, RenderType layer) {
        if (this.type.getCtmPredicate().test(state, side)) {
            Map<BlockState, BakedModel> map = this.modelCache;
            synchronized (map) {
                if (!this.modelCache.containsKey(camoState)) {
                    this.modelCache.put(camoState, this.getCamoModel(camoState));
                }
                BakedModel model = this.modelCache.get(camoState);
                IModelData data = FramedBlockModel.getCamoData(model, camoState, extraData);
                return model.getQuads(camoState, side, rand, data);
            }
        }
        Table<BlockState, RenderType, Map<Direction, List<BakedQuad>>> table = this.quadCacheTable;
        synchronized (table) {
            if (!this.quadCacheTable.contains((Object)camoState, (Object)layer)) {
                this.quadCacheTable.put((Object)camoState, (Object)layer, this.makeQuads(state, camoState, rand, extraData));
            }
            return (List)((Map)this.quadCacheTable.get((Object)camoState, (Object)layer)).get(side);
        }
    }

    private Map<Direction, List<BakedQuad>> makeQuads(BlockState state, BlockState camoState, Random rand, IModelData data) {
        Object2ObjectArrayMap quadMap = new Object2ObjectArrayMap(7);
        quadMap.put(null, new ArrayList());
        for (Direction dir : Direction.values()) {
            quadMap.put(dir, new ArrayList());
        }
        BakedModel camoModel = this.getCamoModel(camoState);
        List quads = FramedBlockModel.getAllQuads(camoModel, camoState, rand, FramedBlockModel.getCamoData(camoModel, camoState, data)).stream().filter(q -> !this.type.getCtmPredicate().test(state, q.m_111306_())).collect(Collectors.toList());
        for (BakedQuad quad : quads) {
            this.transformQuad((Map<Direction, List<BakedQuad>>)quadMap, quad);
        }
        this.postProcessQuads((Map<Direction, List<BakedQuad>>)quadMap);
        this.getAdditionalQuads((Map<Direction, List<BakedQuad>>)quadMap, state, rand, data);
        return quadMap;
    }

    protected abstract void transformQuad(Map<Direction, List<BakedQuad>> var1, BakedQuad var2);

    protected void postProcessQuads(Map<Direction, List<BakedQuad>> quadMap) {
    }

    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data) {
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getModelData();
        }
        return tileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureAtlasSprite getParticleIcon(IModelData data) {
        BlockState camoState;
        if (data instanceof FramedBlockData && (camoState = (BlockState)data.getData(FramedBlockData.CAMO)) != null && !camoState.m_60795_()) {
            Map<BlockState, BakedModel> map = this.modelCache;
            synchronized (map) {
                return this.modelCache.computeIfAbsent(camoState, state -> this.getCamoModel(camoState)).m_6160_();
            }
        }
        return this.baseModel.m_6160_();
    }

    protected BakedModel getCamoModel(BlockState camoState) {
        Block block = camoState.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock fluid = (LiquidBlock)block;
            return this.fluidModels.computeIfAbsent(camoState, state -> new FluidDummyModel((Fluid)fluid.getFluid()));
        }
        return Minecraft.m_91087_().m_91289_().m_110910_(camoState);
    }

    private static IModelData getCamoData(BakedModel model, BlockState state, IModelData data) {
        Level level = (Level)data.getData(FramedBlockData.LEVEL);
        BlockPos pos = (BlockPos)data.getData(FramedBlockData.POS);
        if (level == null || pos == null || pos.equals((Object)BlockPos.f_121853_)) {
            return data;
        }
        return model.getModelData((BlockAndTintGetter)level, pos, state, data);
    }

    protected static List<BakedQuad> getAllQuads(BakedModel model, BlockState state, Random rand, IModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction dir : Direction.values()) {
            if (!FMLEnvironment.production) {
                // empty if block
            }
            quads.addAll(model.getQuads(state, dir, rand, (IModelData)EmptyModelData.INSTANCE));
        }
        return quads;
    }

    private boolean canRenderInLayer(BlockState camoState, RenderType layer) {
        if (camoState == null) {
            return false;
        }
        if (camoState.m_60734_() instanceof LiquidBlock) {
            return ItemBlockRenderTypes.canRenderInLayer((FluidState)camoState.m_60819_(), (RenderType)layer);
        }
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)camoState, (RenderType)layer);
    }
}

