/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedButtonModel
extends FramedBlockModel {
    private final Direction dir;
    private final AttachFace face;
    private final boolean pressed;

    public FramedButtonModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.face = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
        this.pressed = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction facing = this.dir;
        if (this.face == AttachFace.CEILING) {
            facing = Direction.DOWN;
        } else if (this.face == AttachFace.FLOOR) {
            facing = Direction.UP;
        }
        if (facing.m_122434_() == Direction.Axis.Y) {
            float maxZ;
            boolean rotX = this.dir.m_122434_() == Direction.Axis.X;
            float minX = rotX ? 0.375f : 0.3125f;
            float minZ = rotX ? 0.3125f : 0.375f;
            float maxX = rotX ? 0.625f : 0.6875f;
            float f = maxZ = rotX ? 0.6875f : 0.625f;
            if (quad.m_111306_() == facing || quad.m_111306_() == facing.m_122424_()) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, minX, minZ, maxX, maxZ)) {
                    if (quad.m_111306_() == facing) {
                        BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, this.pressed ? 0.0625f : 0.125f);
                        quadMap.get(null).add(topBotQuad);
                    } else {
                        quadMap.get(quad.m_111306_()).add(topBotQuad);
                    }
                }
            } else {
                float minY;
                float maxXZ;
                boolean largeSide = rotX == (quad.m_111306_().m_122434_() == Direction.Axis.X);
                float minXZ = largeSide ? 0.3125f : 0.375f;
                float f2 = maxXZ = largeSide ? 0.6875f : 0.625f;
                float f3 = facing == Direction.DOWN ? (this.pressed ? 0.9375f : 0.875f) : (minY = 0.0f);
                float maxY = facing == Direction.DOWN ? 1.0f : (this.pressed ? 0.0625f : 0.125f);
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, minY, maxXZ, maxY)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, largeSide ? 0.625f : 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        } else if (quad.m_111306_() == facing || quad.m_111306_() == facing.m_122424_()) {
            BakedQuad faceQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(faceQuad, 0.3125f, 0.375f, 0.6875f, 0.625f)) {
                if (quad.m_111306_() == facing) {
                    BakedQuadTransformer.setQuadPosInFacingDir(faceQuad, this.pressed ? 0.0625f : 0.125f);
                    quadMap.get(null).add(faceQuad);
                } else {
                    quadMap.get(quad.m_111306_()).add(faceQuad);
                }
            }
        } else {
            float maxZ;
            float minZ;
            float maxX;
            float minX;
            boolean negative;
            boolean xAxis = facing.m_122434_() == Direction.Axis.X;
            boolean bl = negative = facing.m_122421_() == Direction.AxisDirection.NEGATIVE;
            if (this.pressed) {
                float f = xAxis ? (negative ? 0.9375f : 0.0f) : (minX = 0.3125f);
                float f4 = xAxis ? (negative ? 1.0f : 0.0625f) : (maxX = 0.6875f);
                float f5 = xAxis ? 0.3125f : (minZ = negative ? 0.9375f : 0.0f);
                maxZ = xAxis ? 0.6875f : (negative ? 1.0f : 0.0625f);
            } else {
                float f = xAxis ? (negative ? 0.875f : 0.0f) : (minX = 0.3125f);
                float f6 = xAxis ? (negative ? 1.0f : 0.125f) : (maxX = 0.6875f);
                float f7 = xAxis ? 0.3125f : (minZ = negative ? 0.875f : 0.0f);
                float f8 = xAxis ? 0.6875f : (maxZ = negative ? 1.0f : 0.125f);
            }
            if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, minX, minZ, maxX, maxZ)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            } else {
                float minXZ = xAxis ? minX : minZ;
                float maxXZ = xAxis ? maxX : maxZ;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.375f, maxXZ, 0.625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        }
    }
}

