/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedChestModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_chest_lock");
    private final boolean closed;

    public FramedChestModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.closed = state.m_61143_(PropertyHolder.CHEST_STATE) == ChestState.CLOSED;
    }

    public FramedChestModel(BakedModel baseModel) {
        this(((Block)FBContent.blockFramedChest.get()).m_49966_(), baseModel);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.0625f, 0.0625f, 0.9375f, 0.9375f)) {
                if (topBotQuad.m_111306_() == Direction.UP) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, this.closed ? 0.875f : 0.625f);
                    quadMap.get(null).add(topBotQuad);
                } else {
                    quadMap.get(quad.m_111306_()).add(topBotQuad);
                }
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.0625f, 0.0f, 0.9375f, this.closed ? 0.875f : 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.9375f);
                quadMap.get(null).add(sideQuad);
            }
        }
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data) {
        if (!this.closed) {
            return;
        }
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (!quad.m_173410_().m_118413_().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }
}

