/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedFenceGateModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean inWall;
    private final boolean open;

    public FramedFenceGateModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.inWall = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61442_);
        this.open = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad sideQuad;
        float yOff;
        float f = yOff = this.inWall ? 0.1875f : 0.0f;
        if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122427_(), 0.125f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.5625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 1.0f - yOff : 0.6875f + yOff);
                quadMap.get(this.inWall || quad.m_111306_() == Direction.DOWN ? null : quad.m_111306_()).add(topBotQuad);
            }
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), this.dir.m_122428_(), 0.125f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.5625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 1.0f - yOff : 0.6875f + yOff);
                quadMap.get(this.inWall || quad.m_111306_() == Direction.DOWN ? null : quad.m_111306_()).add(topBotQuad);
            }
        } else if (quad.m_111306_() == this.dir || quad.m_111306_() == this.dir.m_122424_()) {
            BakedQuad sideQuad2 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad2, this.dir.m_122427_(), 0.125f) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad2, true, 0.6875f + yOff) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad2, false, 1.0f - yOff)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad2, 0.5625f);
                quadMap.get(null).add(sideQuad2);
            }
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad2 = ModelUtils.duplicateQuad(quad), this.dir.m_122428_(), 0.125f) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad2, true, 0.6875f + yOff) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad2, false, 1.0f - yOff)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad2, 0.5625f);
                quadMap.get(null).add(sideQuad2);
            }
        } else if ((quad.m_111306_() == this.dir.m_122427_() || quad.m_111306_() == this.dir.m_122428_()) && BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.4375f, 0.3125f - yOff, 0.5625f, 1.0f - yOff)) {
            quadMap.get(quad.m_111306_()).add(sideQuad);
            sideQuad = ModelUtils.duplicateQuad(sideQuad);
            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.125f);
            quadMap.get(null).add(sideQuad);
        }
        if (this.open) {
            this.createGateOpen(quadMap, quad, yOff);
        } else {
            this.createGateClosed(quadMap.get(null), quad, yOff);
        }
    }

    private void createGateClosed(List<BakedQuad> quadList, BakedQuad quad, float yOff) {
        BakedQuad sideQuad;
        if (quad.m_111306_() == this.dir || quad.m_111306_() == this.dir.m_122424_()) {
            BakedQuad sideQuadDup;
            BakedQuad sideQuad2 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad2, 0.375f, 0.375f - yOff, 0.625f, 0.9375f - yOff)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad2, 0.5625f);
                quadList.add(sideQuad2);
            }
            if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad2 = ModelUtils.duplicateQuad(quad), false, 0.5625f - yOff) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad2, true, 0.625f + yOff)) {
                sideQuadDup = ModelUtils.duplicateQuad(sideQuad2);
                if (BakedQuadTransformer.createVerticalSideQuad(sideQuadDup, this.dir.m_122427_(), 0.375f) && BakedQuadTransformer.createVerticalSideQuad(sideQuadDup, this.dir.m_122428_(), 0.875f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuadDup, 0.5625f);
                    quadList.add(sideQuadDup);
                }
                if (BakedQuadTransformer.createVerticalSideQuad(sideQuad2, this.dir.m_122428_(), 0.375f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad2, this.dir.m_122427_(), 0.875f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad2, 0.5625f);
                    quadList.add(sideQuad2);
                }
            }
            if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad2 = ModelUtils.duplicateQuad(quad), false, 0.9375f - yOff) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad2, true, 0.25f + yOff)) {
                sideQuadDup = ModelUtils.duplicateQuad(sideQuad2);
                if (BakedQuadTransformer.createVerticalSideQuad(sideQuadDup, this.dir.m_122427_(), 0.375f) && BakedQuadTransformer.createVerticalSideQuad(sideQuadDup, this.dir.m_122428_(), 0.875f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuadDup, 0.5625f);
                    quadList.add(sideQuadDup);
                }
                if (BakedQuadTransformer.createVerticalSideQuad(sideQuad2, this.dir.m_122428_(), 0.375f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad2, this.dir.m_122427_(), 0.875f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad2, 0.5625f);
                    quadList.add(sideQuad2);
                }
            }
        } else if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122427_(), 0.875f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122428_(), 0.875f)) {
                boolean up = quad.m_111306_() == Direction.UP;
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, up ? 0.9375f - yOff : 0.625f + yOff);
                quadList.add(topBotQuad);
                float height = up ? 0.5625f - yOff : 0.25f + yOff;
                BakedQuad topBotQuadDup = ModelUtils.duplicateQuad(topBotQuad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuadDup, this.dir.m_122427_(), 0.375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuadDup, height);
                    quadList.add(topBotQuadDup);
                }
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuadDup = ModelUtils.duplicateQuad(topBotQuad), this.dir.m_122428_(), 0.375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuadDup, height);
                    quadList.add(topBotQuadDup);
                }
            }
        } else if ((quad.m_111306_() == this.dir.m_122427_() || quad.m_111306_() == this.dir.m_122428_()) && BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.4375f, 0.5625f - yOff, 0.5625f, 0.75f - yOff)) {
            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
            quadList.add(sideQuad);
        }
    }

    private void createGateOpen(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, float yOff) {
        if (quad.m_111306_() == this.dir.m_122427_() || quad.m_111306_() == this.dir.m_122428_()) {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad, this.dir.m_122424_(), 0.4375f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, this.dir, 0.9375f) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad, false, 0.9375f - yOff) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad, true, 0.625f + yOff)) {
                BakedQuad botSideQuad;
                BakedQuad topSideQuad = ModelUtils.duplicateQuad(sideQuad);
                if (BakedQuadTransformer.createHorizontalSideQuad(topSideQuad, true, 0.25f + yOff)) {
                    quadMap.get(quad.m_111306_()).add(topSideQuad);
                    topSideQuad = ModelUtils.duplicateQuad(topSideQuad);
                    BakedQuadTransformer.setQuadPosInFacingDir(topSideQuad, 0.125f);
                    quadMap.get(null).add(topSideQuad);
                }
                if (BakedQuadTransformer.createHorizontalSideQuad(botSideQuad = ModelUtils.duplicateQuad(sideQuad), false, 0.5625f - yOff)) {
                    quadMap.get(quad.m_111306_()).add(botSideQuad);
                    botSideQuad = ModelUtils.duplicateQuad(botSideQuad);
                    BakedQuadTransformer.setQuadPosInFacingDir(botSideQuad, 0.125f);
                    quadMap.get(null).add(botSideQuad);
                }
                if (BakedQuadTransformer.createHorizontalSideQuad(sideQuad, false, 0.75f - yOff) && BakedQuadTransformer.createHorizontalSideQuad(sideQuad, true, 0.4375f + yOff) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, this.dir.m_122424_(), 0.1875f)) {
                    quadMap.get(quad.m_111306_()).add(sideQuad);
                    sideQuad = ModelUtils.duplicateQuad(sideQuad);
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.125f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        } else if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.9375f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.4375f)) {
                BakedQuad rightTopBotQuad;
                boolean up = quad.m_111306_() == Direction.UP;
                float heightOuter = up ? 0.9375f - yOff : 0.625f + yOff;
                float heightInner = up ? 0.5625f - yOff : 0.25f + yOff;
                BakedQuad leftTopBotQuad = ModelUtils.duplicateQuad(topBotQuad);
                if (BakedQuadTransformer.createTopBottomQuad(leftTopBotQuad, this.dir.m_122427_(), 0.125f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(leftTopBotQuad, heightOuter);
                    quadMap.get(null).add(leftTopBotQuad);
                    leftTopBotQuad = ModelUtils.duplicateQuad(leftTopBotQuad);
                    if (BakedQuadTransformer.createTopBottomQuad(leftTopBotQuad, this.dir, 0.8125f)) {
                        BakedQuadTransformer.setQuadPosInFacingDir(leftTopBotQuad, heightInner);
                        quadMap.get(null).add(leftTopBotQuad);
                    }
                }
                if (BakedQuadTransformer.createTopBottomQuad(rightTopBotQuad = ModelUtils.duplicateQuad(topBotQuad), this.dir.m_122428_(), 0.125f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(rightTopBotQuad, heightOuter);
                    quadMap.get(null).add(rightTopBotQuad);
                    rightTopBotQuad = ModelUtils.duplicateQuad(rightTopBotQuad);
                    if (BakedQuadTransformer.createTopBottomQuad(rightTopBotQuad, this.dir, 0.8125f)) {
                        BakedQuadTransformer.setQuadPosInFacingDir(rightTopBotQuad, heightInner);
                        quadMap.get(null).add(rightTopBotQuad);
                    }
                }
            }
        } else if (quad.m_111306_() == this.dir) {
            BakedQuad frontQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(frontQuad, 0.0f, 0.375f - yOff, 0.125f, 0.9375f - yOff)) {
                BakedQuadTransformer.setQuadPosInFacingDir(frontQuad, 0.9375f);
                quadMap.get(null).add(frontQuad);
            }
            if (BakedQuadTransformer.createSideQuad(frontQuad = ModelUtils.duplicateQuad(quad), 0.875f, 0.375f - yOff, 1.0f, 0.9375f - yOff)) {
                BakedQuadTransformer.setQuadPosInFacingDir(frontQuad, 0.9375f);
                quadMap.get(null).add(frontQuad);
            }
        } else if (quad.m_111306_() == this.dir.m_122424_()) {
            BakedQuad backQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(backQuad, 0.0f, 0.5625f - yOff, 0.125f, 0.75f - yOff)) {
                BakedQuadTransformer.setQuadPosInFacingDir(backQuad, 0.1875f);
                quadMap.get(null).add(backQuad);
            }
            if (BakedQuadTransformer.createSideQuad(backQuad = ModelUtils.duplicateQuad(quad), 0.875f, 0.5625f - yOff, 1.0f, 0.75f - yOff)) {
                BakedQuadTransformer.setQuadPosInFacingDir(backQuad, 0.1875f);
                quadMap.get(null).add(backQuad);
            }
        }
    }
}

