/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedDiagonalFenceModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedFenceModel
extends FramedBlockModel {
    private final boolean north;
    private final boolean east;
    private final boolean south;
    private final boolean west;

    public FramedFenceModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.north = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
        this.east = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
        this.south = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
        this.west = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.375f, 0.375f, 0.625f, 0.625f)) {
                quadMap.get(quad.m_111306_()).add(topBotQuad);
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(sideQuad, quad.m_111306_().m_122427_(), 0.625f) && BakedQuadTransformer.createVerticalSideQuad(sideQuad, quad.m_111306_().m_122428_(), 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
        }
        this.createFenceBars(quadMap, quad, Direction.NORTH, this.north);
        this.createFenceBars(quadMap, quad, Direction.EAST, this.east);
        this.createFenceBars(quadMap, quad, Direction.SOUTH, this.south);
        this.createFenceBars(quadMap, quad, Direction.WEST, this.west);
    }

    private void createFenceBars(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean active) {
        if (active) {
            if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
                BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.m_122424_(), 0.375f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.m_122427_(), 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, dir.m_122428_(), 0.5625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 0.9375f : 0.25f);
                    quadMap.get(null).add(topBotQuad);
                    topBotQuad = ModelUtils.duplicateQuad(topBotQuad);
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 0.5625f : 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            } else if (quad.m_111306_() == dir.m_122427_() || quad.m_111306_() == dir.m_122428_()) {
                boolean neg = dir.m_122421_() == Direction.AxisDirection.NEGATIVE;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, neg ? 0.0f : 0.625f, 0.375f, neg ? 0.375f : 1.0f, 0.5625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    quadMap.get(null).add(sideQuad);
                }
                if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), neg ? 0.0f : 0.625f, 0.75f, neg ? 0.375f : 1.0f, 0.9375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                    quadMap.get(null).add(sideQuad);
                }
            } else if (quad.m_111306_() == dir) {
                BakedQuad frontQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(frontQuad, 0.4375f, 0.375f, 0.5625f, 0.5625f)) {
                    quadMap.get(quad.m_111306_()).add(frontQuad);
                }
                if (BakedQuadTransformer.createSideQuad(frontQuad = ModelUtils.duplicateQuad(quad), 0.4375f, 0.75f, 0.5625f, 0.9375f)) {
                    quadMap.get(quad.m_111306_()).add(frontQuad);
                }
            }
        }
    }

    public static BakedModel createFenceModel(BlockState state, BakedModel baseModel) {
        if (ModList.get().isLoaded("diagonalfences")) {
            return new FramedDiagonalFenceModel(state, baseModel);
        }
        return new FramedFenceModel(state, baseModel);
    }
}

