/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedLadderModel
extends FramedBlockModel {
    private static final float RUNG_DEPTH = 0.0625f;
    private static final float RUNG_OFFSET = 0.03125f;
    private static final float[] RUNGS = new float[]{0.09375f, 0.34375f, 0.59375f, 0.84375f};
    private final Direction dir;

    public FramedLadderModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
    }

    public FramedLadderModel(BakedModel baseModel) {
        this((BlockState)((Block)FBContent.blockFramedLadder.get()).m_49966_().m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH), baseModel);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        block12: {
            block13: {
                block11: {
                    if (quad.m_111306_() != Direction.UP && quad.m_111306_() != Direction.DOWN) break block11;
                    BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
                    if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.125f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122427_(), 0.125f)) {
                        quadMap.get(quad.m_111306_()).add(topBotQuad);
                    }
                    if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), this.dir.m_122424_(), 0.125f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122428_(), 0.125f)) {
                        quadMap.get(quad.m_111306_()).add(topBotQuad);
                    }
                    for (int i = 0; i < 4; ++i) {
                        topBotQuad = ModelUtils.duplicateQuad(quad);
                        if (!BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.96875f) || !BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.09375f)) continue;
                        float height = quad.m_111306_() == Direction.DOWN ? 1.0f - RUNGS[i] : RUNGS[i] + 0.0625f;
                        BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, height);
                        quadMap.get(null).add(topBotQuad);
                    }
                    break block12;
                }
                if (quad.m_111306_() != this.dir.m_122427_() && quad.m_111306_() != this.dir.m_122428_()) break block13;
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (!BakedQuadTransformer.createVerticalSideQuad(sideQuad, this.dir.m_122424_(), 0.125f)) break block12;
                quadMap.get(quad.m_111306_()).add(sideQuad);
                sideQuad = ModelUtils.duplicateQuad(sideQuad);
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.125f);
                quadMap.get(null).add(sideQuad);
                break block12;
            }
            if (quad.m_111306_() == this.dir || quad.m_111306_() == this.dir.m_122424_()) {
                boolean opposite = quad.m_111306_() == this.dir.m_122424_();
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createVerticalSideQuad(sideQuad, this.dir.m_122427_(), 0.125f)) {
                    if (opposite) {
                        BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.125f);
                        quadMap.get(null).add(sideQuad);
                    } else {
                        quadMap.get(quad.m_111306_()).add(sideQuad);
                    }
                }
                if (BakedQuadTransformer.createVerticalSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), this.dir.m_122428_(), 0.125f)) {
                    if (opposite) {
                        BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.125f);
                        quadMap.get(null).add(sideQuad);
                    } else {
                        quadMap.get(quad.m_111306_()).add(sideQuad);
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    sideQuad = ModelUtils.duplicateQuad(quad);
                    if (!BakedQuadTransformer.createHorizontalSideQuad(sideQuad, false, RUNGS[i] + 0.0625f) || !BakedQuadTransformer.createHorizontalSideQuad(sideQuad, true, 1.0f - RUNGS[i])) continue;
                    float pos = quad.m_111306_() == this.dir ? 0.96875f : 0.09375f;
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, pos);
                    quadMap.get(null).add(sideQuad);
                }
            }
        }
    }
}

