/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedSignModel
extends FramedBlockModel {
    private static final float Y_OFF = 0.109375f;
    private final Direction dir;
    private final float rotDegrees;

    public FramedSignModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        int rotation = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
        this.dir = Direction.m_122407_((int)(rotation / 4));
        this.rotDegrees = (float)(rotation % 4) * -22.5f;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad botQuad;
        BakedQuad sideQuad;
        if (quad.m_111306_() == this.dir || quad.m_111306_() == this.dir.m_122424_()) {
            BakedQuad faceQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(faceQuad, true, 0.5f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(faceQuad, 0.5625f);
                BakedQuadTransformer.offsetQuadInDir(faceQuad, Direction.UP, 0.109375f);
                BakedQuadTransformer.rotateQuadAroundAxisCentered(faceQuad, Direction.Axis.Y, this.rotDegrees, false);
                quadMap.get(null).add(faceQuad);
            }
        } else if (quad.m_111306_().m_122434_() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.5625f) && BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir.m_122424_(), 0.5625f)) {
                if (quad.m_111306_() == Direction.DOWN) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.5f);
                }
                BakedQuadTransformer.offsetQuadInDir(topBotQuad, Direction.UP, 0.109375f);
                BakedQuadTransformer.rotateQuadAroundAxisCentered(topBotQuad, Direction.Axis.Y, this.rotDegrees, false);
                quadMap.get(null).add(topBotQuad);
            }
        } else {
            sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.4375f, 0.5f, 0.5625f, 1.0f)) {
                BakedQuadTransformer.offsetQuadInDir(sideQuad, Direction.UP, 0.109375f);
                BakedQuadTransformer.rotateQuadAroundAxisCentered(sideQuad, Direction.Axis.Y, this.rotDegrees, false);
                quadMap.get(null).add(sideQuad);
            }
        }
        if (quad.m_111306_().m_122434_() != Direction.Axis.Y) {
            sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.4375f, 0.0f, 0.5625f, 0.609375f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
                BakedQuadTransformer.rotateQuadAroundAxisCentered(sideQuad, Direction.Axis.Y, this.rotDegrees, false);
                quadMap.get(null).add(sideQuad);
            }
        } else if (quad.m_111306_() == Direction.DOWN && BakedQuadTransformer.createTopBottomQuad(botQuad = ModelUtils.duplicateQuad(quad), 0.4375f, 0.4375f, 0.5625f, 0.5625f)) {
            BakedQuadTransformer.rotateQuadAroundAxisCentered(botQuad, Direction.Axis.Y, this.rotDegrees, false);
            quadMap.get(Direction.DOWN).add(botQuad);
        }
    }
}

