/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedWallSignModel
extends FramedBlockModel {
    private final Direction dir;

    public FramedWallSignModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.m_111306_() == this.dir || quad.m_111306_() == this.dir.m_122424_()) {
            BakedQuad faceQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(faceQuad, 0.0f, 0.28125f, 1.0f, 0.78125f)) {
                if (quad.m_111306_() == this.dir) {
                    BakedQuadTransformer.setQuadPosInFacingDir(faceQuad, 0.125f);
                    quadMap.get(null).add(faceQuad);
                } else {
                    quadMap.get(quad.m_111306_()).add(faceQuad);
                }
            }
        } else if (quad.m_111306_() == Direction.UP || quad.m_111306_() == Direction.DOWN) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, this.dir, 0.125f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, quad.m_111306_() == Direction.UP ? 0.78125f : 0.71875f);
                quadMap.get(null).add(topBotQuad);
            }
        } else {
            float maxXZ;
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            boolean dirPositive = this.dir.m_122421_() == Direction.AxisDirection.POSITIVE;
            float minXZ = dirPositive ? 0.0f : 0.875f;
            float f = maxXZ = dirPositive ? 0.125f : 1.0f;
            if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.28125f, maxXZ, 0.78125f)) {
                quadMap.get(quad.m_111306_()).add(sideQuad);
            }
        }
    }
}

