/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;

@Mod.EventBusSubscriber(modid="framedblocks", value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onRenderBlockHighlight(DrawSelectionEvent.HighlightBlock event) {
        if (!ClientConfig.fancyHitboxes) {
            return;
        }
        BlockHitResult result = event.getTarget();
        BlockState state = Minecraft.m_91087_().f_91073_.m_8055_(result.m_82425_());
        Block block = state.m_60734_();
        if (!(block instanceof FramedBlock)) {
            return;
        }
        FramedBlock block2 = (FramedBlock)block;
        BlockType type = block2.getBlockType();
        if (type.hasSpecialHitbox()) {
            PoseStack mstack = event.getMatrix();
            Vec3 offset = Vec3.m_82528_((Vec3i)result.m_82425_()).m_82546_(event.getInfo().m_90583_());
            VertexConsumer builder = event.getBuffers().m_6299_(RenderType.m_110504_());
            Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            mstack.m_85836_();
            mstack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            mstack.m_85837_(0.5, 0.5, 0.5);
            mstack.m_85845_(Vector3f.f_122225_.m_122240_(-dir.m_122435_()));
            mstack.m_85837_(-0.5, -0.5, -0.5);
            switch (type) {
                case FRAMED_SLOPE: {
                    ClientEventHandler.drawSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_CORNER_SLOPE: {
                    ClientEventHandler.drawCornerSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_CORNER_SLOPE: {
                    ClientEventHandler.drawInnerCornerSlopeBox(state, mstack, builder);
                    break;
                }
                case FRAMED_PRISM_CORNER: {
                    ClientEventHandler.drawPrismCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_PRISM_CORNER: {
                    ClientEventHandler.drawInnerPrismCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_THREEWAY_CORNER: {
                    ClientEventHandler.drawThreewayCornerBox(state, mstack, builder);
                    break;
                }
                case FRAMED_INNER_THREEWAY_CORNER: {
                    ClientEventHandler.drawInnerThreewayCornerBox(state, mstack, builder);
                }
            }
            mstack.m_85849_();
            event.setCanceled(true);
        }
    }

    private static void drawSlopeBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (type != SlopeType.HORIZONTAL) {
            if (type == SlopeType.TOP) {
                mstack.m_85837_(0.5, 0.5, 0.5);
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
                mstack.m_85837_(-0.5, -0.5, -0.5);
            }
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        }
    }

    private static void drawCornerSlopeBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            if (type.isTop()) {
                mstack.m_85837_(0.5, 0.5, 0.5);
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
                mstack.m_85837_(-0.5, -0.5, -0.5);
            }
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        } else {
            mstack.m_85837_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.m_85841_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
            }
            mstack.m_85837_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        }
    }

    private static void drawInnerCornerSlopeBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            mstack.m_85837_(0.5, 0.5, 0.5);
            if (type.isTop()) {
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
            }
            mstack.m_85837_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            mstack.m_85837_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.m_85841_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.m_85841_(1.0f, -1.0f, 1.0f);
            }
            mstack.m_85837_(-0.5, -0.5, -0.5);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    private static void drawPrismCornerBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        mstack.m_85837_(0.5, 0.5, 0.5);
        if (top) {
            mstack.m_85841_(1.0f, -1.0f, 1.0f);
        }
        mstack.m_85837_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
    }

    private static void drawInnerPrismCornerBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        mstack.m_85837_(0.5, 0.5, 0.5);
        if (top) {
            mstack.m_85841_(1.0f, -1.0f, 1.0f);
        }
        mstack.m_85837_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
    }

    private static void drawThreewayCornerBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        mstack.m_85837_(0.5, 0.5, 0.5);
        if (top) {
            mstack.m_85841_(1.0f, -1.0f, 1.0f);
        }
        mstack.m_85837_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5);
    }

    private static void drawInnerThreewayCornerBox(BlockState state, PoseStack mstack, VertexConsumer builder) {
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        mstack.m_85837_(0.5, 0.5, 0.5);
        if (top) {
            mstack.m_85841_(1.0f, -1.0f, 1.0f);
        }
        mstack.m_85837_(-0.5, -0.5, -0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0);
        ClientEventHandler.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        ClientEventHandler.drawLine(builder, mstack, 0.5, 0.5, 0.5, 0.0, 1.0, 1.0);
        ClientEventHandler.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.5, 0.5, 0.5);
    }

    private static void drawLine(VertexConsumer builder, PoseStack mstack, double x1, double y1, double z1, double x2, double y2, double z2) {
        float nX = (float)(x2 - x1);
        float nY = (float)(y2 - y1);
        float nZ = (float)(z2 - z1);
        float nLen = Mth.m_14116_((float)(nX * nX + nY * nY + nZ * nZ));
        builder.m_85982_(mstack.m_85850_().m_85861_(), (float)x1, (float)y1, (float)z1).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(mstack.m_85850_().m_85864_(), nX /= nLen, nY /= nLen, nZ /= nLen).m_5752_();
        builder.m_85982_(mstack.m_85850_().m_85861_(), (float)x2, (float)y2, (float)z2).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(mstack.m_85850_().m_85864_(), nX, nY, nZ).m_5752_();
    }
}

