/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.Utils;

public class FramedBlock
extends Block
implements IFramedBlock,
SimpleWaterloggedBlock {
    private final BlockType blockType;
    private final Map<BlockState, VoxelShape> shapes;

    public FramedBlock(BlockType blockType) {
        this(blockType, IFramedBlock.createProperties());
    }

    protected FramedBlock(BlockType blockType, BlockBehaviour.Properties props) {
        super(props);
        this.blockType = blockType;
        this.shapes = blockType.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
        if (blockType.supportsWaterLogging()) {
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (this.isWaterLoggable() && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_6217_().m_5945_(pos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getLight(level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getCamoSound(state, level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes.get(state);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getCamoSlipperiness(state, level, pos, entity);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getCamoExplosionResistance(state, level, pos, explosion);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.isCamoFlammable(level, pos, face);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getCamoFlammability(level, pos, face);
    }

    public FluidState m_5888_(BlockState state) {
        if (this.isWaterLoggable() && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return Fluids.f_76191_.m_76145_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedBlockEntity(pos, state);
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (!this.isWaterLoggable()) {
            return false;
        }
        return super.m_6044_(level, pos, state, fluid);
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!this.isWaterLoggable()) {
            return ItemStack.f_41583_;
        }
        return super.m_142598_(level, pos, state);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    protected BlockState withSlopeType(BlockState state, Direction side, Direction facing, Vec3 hitVec) {
        state = (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        Vec3 hitPoint = Utils.fraction(hitVec);
        if (side.m_122434_() != Direction.Axis.Y) {
            if (hitPoint.m_7098_() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.m_7098_() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        if (side == Direction.DOWN) {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.BOTTOM));
        } else {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.HORIZONTAL));
            boolean xAxis = side.m_122434_() == Direction.Axis.X;
            boolean positive = side.m_122428_().m_122421_() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.m_7094_() : hitPoint.m_7096_();
            state = xz > 0.5 == positive ? (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)side.m_122424_().m_122427_()) : (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)side.m_122424_());
        }
        return state;
    }

    protected BlockState withCornerType(BlockState state, BlockPlaceContext context, Direction side, Vec3 hitPoint, Direction facing) {
        state = (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        if (side == Direction.DOWN) {
            state = (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.BOTTOM));
        } else {
            boolean xAxis = context.m_43719_().m_122434_() == Direction.Axis.X;
            boolean positive = context.m_43719_().m_122428_().m_122421_() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.m_7094_() : hitPoint.m_7096_();
            double y = hitPoint.m_7098_();
            CornerType type = xz > 0.5 == positive ? (y > 0.5 ? CornerType.HORIZONTAL_TOP_RIGHT : CornerType.HORIZONTAL_BOTTOM_RIGHT) : (y > 0.5 ? CornerType.HORIZONTAL_TOP_LEFT : CornerType.HORIZONTAL_BOTTOM_LEFT);
            state = (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type));
        }
        return state;
    }

    protected BlockState withTop(BlockState state, Direction side, Vec3 hitVec) {
        if (side == Direction.DOWN) {
            state = (BlockState)state.m_61124_((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(true));
        } else if (side == Direction.UP) {
            state = (BlockState)state.m_61124_((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(false));
        } else {
            double y = hitVec.f_82480_;
            state = (BlockState)state.m_61124_((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf((y -= Math.floor(y)) >= 0.5));
        }
        return state;
    }

    protected BlockState withWater(BlockState state, LevelReader level, BlockPos pos) {
        FluidState fluidState = level.m_6425_(pos);
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    protected boolean isWaterLoggable() {
        return this.blockType.supportsWaterLogging();
    }
}

