/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleCornerBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedDoubleCornerBlock
extends AbstractFramedDoubleBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType type = (CornerType)((Object)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE)));
        if (type.isHorizontal()) {
            if (side == null) {
                return false;
            }
            return side == dir || side == dir.m_122424_() || side == dir.m_122428_() && !type.isRight() || side == dir.m_122427_() && type.isRight() || side == Direction.DOWN && !type.isTop() || side == Direction.UP && type.isTop();
        }
        return side != null && side.m_122434_() == Direction.Axis.Y || side == dir || side == dir.m_122428_();
    };

    public FramedDoubleCornerBlock() {
        super(BlockType.FRAMED_DOUBLE_CORNER);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.CORNER_TYPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction side = context.m_43719_();
        Vec3 hitPoint = Utils.fraction(context.m_43720_());
        if (side.m_122434_() != Direction.Axis.Y) {
            if (hitPoint.m_7098_() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.m_7098_() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        return this.withCornerType(state, context, side, hitPoint, context.m_8125_());
    }

    @Override
    public SoundType getCamoSound(BlockState state, LevelReader level, BlockPos pos) {
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            BlockState camoState;
            FramedDoubleBlockEntity dbe = (FramedDoubleBlockEntity)blockEntity;
            BlockState blockState = camoState = type.isHorizontal() || type.isTop() ? dbe.getCamoState() : dbe.getCamoStateTwo();
            if (!camoState.m_60795_()) {
                return camoState.m_60827_();
            }
            BlockState blockState2 = camoState = type.isHorizontal() || type.isTop() ? dbe.getCamoStateTwo() : dbe.getCamoState();
            if (!camoState.m_60795_()) {
                return camoState.m_60827_();
            }
        }
        return this.m_49962_(state);
    }

    @Override
    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDoubleCornerBlockEntity(pos, state);
    }
}

