/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlabCornerBlock
extends FramedBlock {
    public FramedSlabCornerBlock() {
        super(BlockType.FRAMED_SLAB_CORNER);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.TOP, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction face = context.m_43719_();
        Vec3 hitPoint = Utils.fraction(context.m_43720_());
        if (face.m_122434_().m_122479_()) {
            boolean xAxis = face.m_122434_() == Direction.Axis.X;
            boolean positive = face.m_122428_().m_122421_() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.m_7094_() : hitPoint.m_7096_();
            Direction dir = face.m_122424_();
            if (xz > 0.5 == positive) {
                dir = dir.m_122427_();
            }
            state = (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)dir);
        } else {
            double z;
            Direction dir;
            double x = hitPoint.m_7096_();
            if (x > 0.5 == ((dir = (z = hitPoint.m_7094_()) > 0.5 ? Direction.SOUTH : Direction.NORTH).m_122421_() == Direction.AxisDirection.NEGATIVE)) {
                dir = dir.m_122427_();
            }
            state = (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)dir);
        }
        state = this.withTop(state, face, context.m_43720_());
        return this.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBot = FramedSlabCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
        VoxelShape shapeTop = FramedSlabCornerBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, top ? shapeTop : shapeBot));
        }
        return builder.build();
    }
}

