/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlopeBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        SlopeType type = (SlopeType)((Object)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE)));
        if (dir == Direction.UP && type == SlopeType.TOP) {
            return true;
        }
        if (dir == Direction.DOWN && type == SlopeType.BOTTOM) {
            return true;
        }
        if (type == SlopeType.HORIZONTAL) {
            Direction facing = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            return dir == facing || dir == facing.m_122428_();
        }
        return state.m_61143_((Property)PropertyHolder.FACING_HOR) == dir;
    };

    public FramedSlopeBlock() {
        super(BlockType.FRAMED_SLOPE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.withSlopeType(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
        return this.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).m_83296_();
        VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).m_83296_();
        VoxelShape shapeHorizontal = Shapes.m_83124_((VoxelShape)FramedSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedSlopeBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedSlopeBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedSlopeBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)}).m_83296_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
            Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
            if (type == SlopeType.BOTTOM) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeBottom));
                continue;
            }
            if (type == SlopeType.TOP) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeTop));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shapeHorizontal));
        }
        return builder.build();
    }
}

