/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;
import xfacthd.framedblocks.common.util.CommonConfig;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public interface IFramedBlock
extends EntityBlock {
    public BlockType getBlockType();

    public static BlockBehaviour.Properties createProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60955_().m_60978_(2.0f).m_60918_(SoundType.f_56736_);
    }

    default public BlockItem createItemBlock() {
        Block block = (Block)this;
        BlockItem item = new BlockItem(block, new Item.Properties().m_41491_(FramedBlocks.FRAMED_TAB));
        item.setRegistryName(block.getRegistryName());
        return item;
    }

    default public void tryApplyCamoImmediately(Level level, BlockPos pos, @Nullable LivingEntity placer, ItemStack stack) {
        LivingEntity livingEntity;
        if (!level.m_5776_() && (livingEntity = placer) instanceof Player) {
            FramedBlockEntity be;
            BlockEntity blockEntity;
            BlockItem item;
            Player player = (Player)livingEntity;
            if (player.m_21205_() != stack) {
                return;
            }
            ItemStack otherStack = player.m_21206_();
            Item item2 = otherStack.m_41720_();
            if (item2 instanceof BlockItem && !((item = (BlockItem)item2).m_40614_() instanceof IFramedBlock) && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity && !((be = (FramedBlockEntity)blockEntity) instanceof FramedDoubleBlockEntity)) {
                Vec3 hitVec = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                be.handleInteraction(player, InteractionHand.OFF_HAND, new BlockHitResult(hitVec, Direction.UP, pos, false));
            }
        }
    }

    default public InteractionResult handleUse(Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.handleInteraction(player, hand, hit);
        }
        return InteractionResult.FAIL;
    }

    default public int getLight(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getLightValue();
        }
        return 0;
    }

    default public SoundType getCamoSound(BlockState state, LevelReader level, BlockPos pos) {
        FramedBlockEntity be;
        BlockState camoState;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && !(camoState = (be = (FramedBlockEntity)blockEntity).getCamoState()).m_60795_()) {
            return camoState.m_60827_();
        }
        return ((Block)this).m_49962_(state);
    }

    default public List<ItemStack> getCamoDrops(List<ItemStack> drops, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof FramedBlockEntity) {
            FramedDoubleBlockEntity dbe;
            FramedBlockEntity framedBlockEntity;
            FramedBlockEntity be = (FramedBlockEntity)((Object)object);
            ItemStack camo = be.getCamoStack();
            if (!camo.m_41619_()) {
                drops.add(camo);
            }
            if ((framedBlockEntity = be) instanceof FramedDoubleBlockEntity && !(camo = (dbe = (FramedDoubleBlockEntity)framedBlockEntity).getCamoStackTwo()).m_41619_()) {
                drops.add(camo);
            }
        }
        return drops;
    }

    default public CtmPredicate getCtmPredicate() {
        return this.getBlockType().getCtmPredicate();
    }

    @Nonnull
    @Deprecated
    default public BlockState getFacadeDisabled(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable Direction side) {
        return Blocks.f_50016_.m_49966_();
    }

    @Nonnull
    default public BlockState getFacadeDisabled(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable Direction side, @Nonnull BlockPos connection) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (this.getCtmPredicate().test(state, side) && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.getCamoState();
        }
        return Blocks.f_50016_.m_49966_();
    }

    default public boolean isSideHidden(BlockGetter level, BlockPos pos, BlockState state, Direction side) {
        if (level == null) {
            return false;
        }
        SideSkipPredicate pred = ClientConfig.detailedCulling ? this.getBlockType().getSideSkipPredicate() : SideSkipPredicate.CTM;
        return pred.test(level, pos, state, level.m_8055_(pos.m_142300_(side)), side);
    }

    default public float getCamoSlipperiness(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        FramedBlockEntity be;
        BlockState camoState;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && !(camoState = (be = (FramedBlockEntity)blockEntity).getCamoState(Direction.UP)).m_60795_()) {
            return camoState.getFriction(level, pos, entity);
        }
        return state.m_60734_().m_49958_();
    }

    default public float getCamoExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        FramedBlockEntity be;
        float resistance;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (resistance = (be = (FramedBlockEntity)blockEntity).getCamoExplosionResistance(explosion)) > 0.0f) {
            return resistance;
        }
        return state.m_60734_().m_7325_();
    }

    default public boolean isCamoFlammable(BlockGetter level, BlockPos pos, Direction face) {
        if (CommonConfig.fireproofBlocks) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.isCamoFlammable(face);
        }
        return true;
    }

    default public int getCamoFlammability(BlockGetter level, BlockPos pos, Direction face) {
        FramedBlockEntity be;
        int flammability;
        if (CommonConfig.fireproofBlocks) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity && (flammability = (be = (FramedBlockEntity)blockEntity).getCamoFlammability(face)) > -1) {
            return flammability;
        }
        return 20;
    }

    default public MutableComponent printCamoBlock(CompoundTag beTag) {
        BlockState camoState = NbtUtils.m_129241_((CompoundTag)beTag.m_128469_("camo_state"));
        return camoState.m_60795_() ? FramedBlueprintItem.BLOCK_NONE : camoState.m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE);
    }
}

