/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.util.Utils;

public class FramedBlockEntity
extends BlockEntity {
    public static final TranslatableComponent MSG_BLACKLISTED = new TranslatableComponent("msg.framedblocks.blacklisted");
    public static final TranslatableComponent MSG_BLOCK_ENTITY = new TranslatableComponent("msg.framedblocks.block_entity");
    private static final ImmutableList<Block> BLOCK_ENTITY_WHITELIST = FramedBlockEntity.buildBlockEntityWhitelist();
    private final FramedBlockData modelData = new FramedBlockData();
    private ItemStack camoStack = ItemStack.f_41583_;
    private BlockState camoState = Blocks.f_50016_.m_49966_();
    private boolean glowing = false;

    public FramedBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FBContent.blockEntityTypeFramedBlock.get(), pos, state);
    }

    protected FramedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public InteractionResult handleInteraction(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        BlockState camo = this.getCamoState(hit);
        if (!camo.m_60795_() && !(camo.m_60734_() instanceof LiquidBlock) && stack.m_41720_() == FBContent.itemFramedHammer.get()) {
            return this.clearBlockCamo(player, hit);
        }
        if (!camo.m_60795_() && camo.m_60734_() instanceof LiquidBlock && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return InteractionResult.PASS;
        }
        if (camo.m_60795_() && stack.m_41720_() instanceof BlockItem) {
            return this.setBlockCamo(player, stack, hit);
        }
        if (camo.m_60795_() && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return InteractionResult.PASS;
        }
        if (stack.m_150922_((Tag)Tags.Items.DUSTS_GLOWSTONE) && !this.glowing) {
            if (!this.f_58857_.m_5776_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.glowing = true;
                this.m_6596_();
                this.doLightUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (!camo.m_60795_() && stack.m_150922_(Utils.WRENCH)) {
            return this.rotateCamo(camo, hit);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult clearBlockCamo(Player player, BlockHitResult hit) {
        if (!this.f_58857_.m_5776_()) {
            int light = this.getLightValue();
            ItemStack camoStack = this.getCamoStack(hit);
            if (!player.m_150109_().m_36054_(camoStack)) {
                player.m_36176_(camoStack, false);
            }
            this.applyCamo(ItemStack.f_41583_, Blocks.f_50016_.m_49966_(), hit);
            boolean lightUpdate = this.getLightValue() != light;
            this.m_6596_();
            if (lightUpdate) {
                this.doLightUpdate();
            }
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
    }

    private InteractionResult clearFluidCamo(Player player, BlockState camo, ItemStack stack, BlockHitResult hit) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        return cap.map(handler -> {
            FluidStack fluid = new FluidStack((Fluid)((LiquidBlock)camo.m_60734_()).getFluid(), 1000);
            if (handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                if (!this.f_58857_.m_5776_()) {
                    if (!player.m_7500_()) {
                        if (stack.m_41720_() == Items.f_42446_) {
                            stack.m_41774_(1);
                            ItemStack result = new ItemStack((ItemLike)fluid.getFluid().m_6859_());
                            if (!player.m_150109_().m_36054_(result)) {
                                player.m_36176_(result, false);
                            }
                        } else {
                            handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    int light = this.getLightValue();
                    this.applyCamo(ItemStack.f_41583_, Blocks.f_50016_.m_49966_(), hit);
                    boolean lightUpdate = this.getLightValue() != light;
                    this.m_6596_();
                    if (lightUpdate) {
                        this.doLightUpdate();
                    }
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
                return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
            }
            return InteractionResult.FAIL;
        }).orElse(InteractionResult.FAIL);
    }

    private InteractionResult setBlockCamo(Player player, ItemStack stack, BlockHitResult hit) {
        BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
        if (this.isValidBlock(state, player)) {
            if (!this.f_58857_.m_5776_()) {
                int light = this.getLightValue();
                this.applyCamo(stack.m_41620_(1), state, hit);
                if (player.m_7500_()) {
                    stack.m_41769_(1);
                }
                this.m_6596_();
                if (this.getLightValue() != light) {
                    this.doLightUpdate();
                }
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult setFluidCamo(Player player, ItemStack stack, BlockHitResult hit) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        return cap.map(handler -> {
            FluidStack fluid = handler.getFluidInTank(0);
            BlockState state = (BlockState)fluid.getFluid().m_76145_().m_76188_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(8));
            if (!state.m_60795_()) {
                ItemStack bucket = new ItemStack((ItemLike)fluid.getFluid().m_6859_());
                if (fluid.getAmount() >= 1000 && !bucket.m_41619_() && handler.drain(1000, IFluidHandler.FluidAction.SIMULATE).getAmount() == 1000) {
                    if (!this.f_58857_.m_5776_()) {
                        if (!player.m_7500_()) {
                            if (stack.m_41720_() instanceof BucketItem) {
                                stack.m_41774_(1);
                                ItemStack emptyBucket = new ItemStack((ItemLike)Items.f_42446_);
                                if (!player.m_150109_().m_36054_(emptyBucket)) {
                                    player.m_36176_(emptyBucket, false);
                                }
                            } else {
                                handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                        int light = this.getLightValue();
                        this.applyCamo(ItemStack.f_41583_, state, hit);
                        this.m_6596_();
                        if (this.getLightValue() != light) {
                            this.doLightUpdate();
                        }
                        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
                }
            }
            return InteractionResult.FAIL;
        }).orElse(InteractionResult.FAIL);
    }

    private InteractionResult rotateCamo(BlockState camo, BlockHitResult hit) {
        Property<?> prop = this.getRotatableProperty(camo);
        if (prop != null) {
            if (!this.f_58857_.m_5776_()) {
                this.applyCamo(this.getCamoStack(hit), (BlockState)camo.m_61122_(prop), hit);
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    private Property<?> getRotatableProperty(BlockState state) {
        for (Property prop : state.m_61147_()) {
            if (prop.m_61709_() == Direction.Axis.class) {
                return prop;
            }
            if (!(prop instanceof DirectionProperty)) continue;
            return prop;
        }
        return null;
    }

    protected boolean isValidBlock(BlockState state, Player player) {
        Block block = state.m_60734_();
        if (block instanceof IFramedBlock) {
            return false;
        }
        if (state.m_60620_(Utils.BLACKLIST)) {
            player.m_5661_((Component)MSG_BLACKLISTED, true);
            return false;
        }
        if (state.m_155947_() && !BLOCK_ENTITY_WHITELIST.contains((Object)block)) {
            player.m_5661_((Component)MSG_BLOCK_ENTITY, true);
            return false;
        }
        return state.m_60804_((BlockGetter)this.f_58857_, this.f_58858_) || state.m_60620_(Utils.FRAMEABLE);
    }

    protected void applyCamo(ItemStack camoStack, BlockState camoState, BlockHitResult hit) {
        this.camoStack = camoStack;
        this.camoState = camoState;
    }

    public void setCamo(ItemStack camoStack, BlockState camoState, boolean secondary) {
        int light = this.getLightValue();
        this.camoStack = camoStack;
        this.camoState = camoState;
        this.m_6596_();
        if (this.getLightValue() != light) {
            this.doLightUpdate();
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean isSolidSide(Direction side) {
        return this.getBlock().getCtmPredicate().test(this.m_58900_(), side) && this.camoState.m_60815_();
    }

    public BlockState getCamoState(Direction side) {
        return this.camoState;
    }

    protected BlockState getCamoState(BlockHitResult hit) {
        return this.camoState;
    }

    public BlockState getCamoState() {
        return this.camoState;
    }

    protected ItemStack getCamoStack(BlockHitResult hit) {
        return this.camoStack;
    }

    public ItemStack getCamoStack() {
        return this.camoStack;
    }

    public float getCamoExplosionResistance(Explosion explosion) {
        return this.camoState.getExplosionResistance((BlockGetter)this.f_58857_, this.f_58858_, explosion);
    }

    public boolean isCamoFlammable(Direction face) {
        return this.camoState.m_60795_() || this.camoState.isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face);
    }

    public int getCamoFlammability(Direction face) {
        return this.getCamoState().m_60795_() ? -1 : this.getCamoState().getFlammability((BlockGetter)this.f_58857_, this.f_58858_, face);
    }

    public void setGlowing(boolean glowing) {
        if (this.glowing != glowing) {
            int oldLight = this.getLightValue();
            this.glowing = glowing;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public int getLightValue() {
        if (this.glowing) {
            return 15;
        }
        return this.camoState.m_60791_();
    }

    protected void doLightUpdate() {
        this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
    }

    public final IFramedBlock getBlock() {
        return (IFramedBlock)this.m_58900_().m_60734_();
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag nbt = new CompoundTag();
        this.writeToDataPacket(nbt);
        return new ClientboundBlockEntityDataPacket(this.f_58858_, -1, nbt);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (this.readFromDataPacket(nbt)) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void writeToDataPacket(CompoundTag nbt) {
        nbt.m_128365_("camo_stack", (net.minecraft.nbt.Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state", (net.minecraft.nbt.Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        nbt.m_128379_("glowing", this.glowing);
    }

    protected boolean readFromDataPacket(CompoundTag nbt) {
        boolean newGlow;
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack"));
        boolean needUpdate = false;
        BlockState newState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state"));
        if (newState != this.camoState) {
            int oldLight = this.getLightValue();
            this.camoState = newState;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.modelData.setLevel(this.f_58857_);
            this.modelData.setPos(this.f_58858_);
            this.modelData.setCamoState(this.camoState);
            needUpdate = true;
        }
        if ((newGlow = nbt.m_128471_("glowing")) != this.glowing) {
            this.glowing = newGlow;
            needUpdate = true;
            this.doLightUpdate();
        }
        return needUpdate;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("camo_stack", (net.minecraft.nbt.Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state", (net.minecraft.nbt.Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        nbt.m_128379_("glowing", this.glowing);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack"));
        BlockState newState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setLevel(this.f_58857_);
            this.modelData.setPos(this.f_58858_);
            this.modelData.setCamoState(this.camoState);
        }
        this.glowing = nbt.m_128471_("glowing");
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    public CompoundTag writeToBlueprint() {
        return this.m_6945_(new CompoundTag());
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        nbt.m_128365_("camo_stack", (net.minecraft.nbt.Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state", (net.minecraft.nbt.Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        nbt.m_128379_("glowing", this.glowing);
        return super.m_6945_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack"));
        this.camoState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state"));
        this.glowing = nbt.m_128471_("glowing");
    }

    private static ImmutableList<Block> buildBlockEntityWhitelist() {
        return ImmutableList.builder().add((Object)Blocks.f_50131_).build();
    }
}

