/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedBlockEntity;

public class FramedSignBlockEntity
extends FramedBlockEntity {
    private final Component[] lines = new Component[4];
    private final FormattedCharSequence[] renderLines = new FormattedCharSequence[4];
    private DyeColor textColor = DyeColor.BLACK;
    private Player editingPlayer;

    public FramedSignBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedSign.get(), pos, state);
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = new TextComponent("");
        }
    }

    public void setLine(int line, Component text) {
        this.lines[line] = text;
        this.renderLines[line] = null;
    }

    public Component getLine(int line) {
        return this.lines[line];
    }

    public FormattedCharSequence getRenderedLine(int line, Function<Component, FormattedCharSequence> converter) {
        if (this.lines[line] != null && this.renderLines[line] == null) {
            this.renderLines[line] = converter.apply(this.lines[line]);
        }
        return this.renderLines[line];
    }

    public boolean executeCommand(ServerPlayer player) {
        for (Component line : this.lines) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = line == null ? null : line.m_7383_();
            if (style == null || style.m_131182_() == null || (clickevent = style.m_131182_()).m_130622_() != ClickEvent.Action.RUN_COMMAND) continue;
            player.m_20194_().m_129892_().m_82117_(this.getCommandSource(player), clickevent.m_130623_());
        }
        return true;
    }

    private CommandSourceStack getCommandSource(ServerPlayer player) {
        String nameString = player == null ? "Sign" : player.m_7755_().getString();
        TextComponent name = player == null ? new TextComponent("Sign") : player.m_5446_();
        Vec3 posVec = new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
        return new CommandSourceStack(CommandSource.f_80164_, posVec, Vec2.f_82462_, (ServerLevel)this.f_58857_, 2, nameString, (Component)name, this.f_58857_.m_142572_(), (Entity)player);
    }

    public boolean setTextColor(DyeColor color) {
        if (this.textColor != color) {
            this.textColor = color;
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            return true;
        }
        return false;
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public Player getEditingPlayer() {
        return this.editingPlayer;
    }

    public void setEditingPlayer(Player player) {
        this.editingPlayer = player;
    }

    public boolean m_6326_() {
        return true;
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        this.writeToNbt(nbt);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        this.readFromNbt(nbt);
        return super.readFromDataPacket(nbt);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeToNbt(nbt);
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.readFromNbt(nbt);
    }

    private void writeToNbt(CompoundTag nbt) {
        for (int i = 0; i < 4; ++i) {
            nbt.m_128359_("text" + i, Component.Serializer.m_130703_((Component)this.lines[i]));
        }
        nbt.m_128359_("color", this.textColor.m_41065_());
    }

    private void readFromNbt(CompoundTag nbt) {
        for (int i = 0; i < 4; ++i) {
            String s = nbt.m_128461_("text" + i);
            MutableComponent line = Component.Serializer.m_130701_((String)(s.isEmpty() ? "\"\"" : s));
            if (this.f_58857_ instanceof ServerLevel && line != null) {
                try {
                    this.lines[i] = ComponentUtils.m_130731_((CommandSourceStack)this.getCommandSource(null), (Component)line, null, (int)0);
                }
                catch (CommandSyntaxException e) {
                    this.lines[i] = line;
                }
            } else {
                this.lines[i] = line;
            }
            this.renderLines[i] = null;
        }
        this.textColor = DyeColor.m_41057_((String)nbt.m_128461_("color"), (DyeColor)DyeColor.BLACK);
    }

    @Override
    public CompoundTag writeToBlueprint() {
        return super.m_6945_(new CompoundTag());
    }

    @Override
    public CompoundTag m_6945_(CompoundTag nbt) {
        this.writeToNbt(nbt);
        return super.m_6945_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readFromNbt(nbt);
    }
}

