/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class InnerCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Block block = adjState.m_60734_();
        if (!(block instanceof IFramedBlock)) {
            return false;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        BlockType adjBlock = block2.getBlockType();
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
        if (adjBlock == BlockType.FRAMED_INNER_CORNER_SLOPE) {
            return this.testAgainstInnerCorner(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_CORNER_SLOPE) {
            return this.testAgainstCorner(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_CORNER) {
            return this.testAgainstDoubleCorner(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_SLOPE) {
            return this.testAgainstSlope(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_SLOPE) {
            return this.testAgainstDoubleSlope(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_PRISM_CORNER || adjBlock == BlockType.FRAMED_THREEWAY_CORNER) {
            return this.testAgainstThreewaySlope(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_PRISM_CORNER || adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            return this.testAgainstInnerThreewaySlope(level, pos, dir, type, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_PRISM_CORNER || adjBlock == BlockType.FRAMED_DOUBLE_THREEWAY_CORNER) {
            return this.testAgainstDoubleThreewayCorner(level, pos, dir, type, adjState, side);
        }
        return false;
    }

    private boolean testAgainstInnerCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal() && adjType == type && (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (type.isHorizontal() && type.isHorizontalAdjacentInner(dir, side, adjType) && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (!type.isHorizontal() && adjType.isHorizontal() && adjType.isTop() == type.isTop() && (side == dir.m_122427_() && adjType.isRight() && adjDir == dir || side == dir.m_122424_() && !adjType.isRight() && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (type.isHorizontal() && !adjType.isHorizontal() && adjType.isTop() == type.isTop() && (!type.isRight() && side == dir.m_122427_() && adjDir == dir.m_122427_() || type.isRight() && side == dir.m_122428_() && adjDir == dir)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal() && !adjType.isHorizontal() && adjDir == dir && adjType.isTop() == type.isTop()) {
            return (side == dir.m_122427_() || side == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side);
        }
        if (type.isHorizontal() && adjType == type && adjDir == dir && (side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop() || side == dir.m_122427_() && !type.isRight() || side == dir.m_122428_() && type.isRight())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (!type.isHorizontal() && adjType.isHorizontal() && adjType.isTop() == type.isTop() && (side == dir.m_122427_() && !adjType.isRight() && adjDir == dir || side == dir.m_122424_() && adjType.isRight() && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (type.isHorizontal() && !adjType.isHorizontal() && adjType.isTop() == type.isTop() && (!type.isRight() && side == dir.m_122427_() && adjDir == dir || type.isRight() && side == dir.m_122428_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoubleCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal() && !adjType.isHorizontal()) {
            if (type.isTop() == adjType.isTop() && (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
            if (type.isTop() != adjType.isTop() && adjDir == dir.m_122424_() && (side == dir.m_122427_() || side == dir.m_122424_())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (type.isHorizontal() && !adjType.isHorizontal()) {
            if (type.isTop() == adjType.isTop() && (side == dir.m_122428_() && adjDir == dir && type.isRight() || side == dir.m_122427_() && adjDir == dir.m_122427_() && !type.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
            if (type.isTop() != adjType.isTop() && (side == dir.m_122427_() && adjDir == dir.m_122424_() && !type.isRight() || side == dir.m_122428_() && adjDir == dir.m_122428_() && type.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else if (!type.isHorizontal()) {
            if (type.isTop() == adjType.isTop() && (side == dir.m_122427_() && adjDir == dir && adjType.isRight() || side == dir.m_122424_() && adjDir == dir.m_122428_() && !adjType.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, adjDir);
            }
            if (type.isTop() != adjType.isTop() && (side == dir.m_122427_() && adjDir == dir.m_122424_() && !adjType.isRight() || side == dir.m_122424_() && adjDir == dir.m_122427_() && adjType.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
            }
        } else if (adjDir == dir) {
            if (type.isRight() == adjType.isRight() && (side == Direction.UP && !type.isTop() && adjType.isTop() || side == Direction.DOWN && type.isTop() && !adjType.isTop())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (type.isTop() == adjType.isTop() && (side == dir.m_122427_() && !type.isRight() && adjType.isRight() || side == dir.m_122428_() && type.isRight() && !adjType.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        } else if (adjDir == dir.m_122424_()) {
            if (type.isRight() == adjType.isRight() && (side == Direction.UP && !type.isTop() && adjType.isTop() || side == Direction.DOWN && type.isTop() && !adjType.isTop())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (type.isRight() == adjType.isRight() && type.isTop() != adjType.isTop() && (side == dir.m_122428_() && type.isRight() || side == dir.m_122427_() && !type.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        }
        return false;
    }

    private boolean testAgainstSlope(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (!type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir.m_122427_() && adjDir == dir || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
            return adjType == SlopeType.TOP == type.isTop() && SideSkipPredicate.compareState(level, pos, side);
        }
        if (type.isHorizontal()) {
            if ((side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop()) && adjType == SlopeType.HORIZONTAL) {
                return (!type.isRight() && adjDir == dir || type.isRight() && adjDir == dir.m_122427_()) && SideSkipPredicate.compareState(level, pos, side);
            }
            if (side.m_122434_() != Direction.Axis.Y && adjDir == dir && adjType == SlopeType.TOP == type.isTop()) {
                return (!type.isRight() && side == dir.m_122427_() || type.isRight() && side == dir.m_122428_()) && SideSkipPredicate.compareState(level, pos, side);
            }
        }
        return false;
    }

    private boolean testAgainstDoubleSlope(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        boolean bl = adjTop = adjType == SlopeType.TOP;
        if (!type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir.m_122427_() && type.isTop() == adjTop && adjDir == dir || side == dir.m_122427_() && type.isTop() != adjTop && adjDir == dir.m_122424_() || side == dir.m_122424_() && type.isTop() == adjTop && adjDir == dir.m_122428_() || side == dir.m_122424_() && type.isTop() != adjTop && adjDir == dir.m_122427_())) {
            Direction face = type.isTop() == adjTop ? adjDir : adjDir.m_122424_();
            return SideSkipPredicate.compareState(level, pos, side, face);
        }
        if (type.isHorizontal() && adjType == SlopeType.HORIZONTAL && (side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop())) {
            if (!type.isRight() && (adjDir == dir || adjDir == dir.m_122424_()) || type.isRight() && (adjDir == dir.m_122427_() || adjDir == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        } else if (type.isHorizontal() && adjType != SlopeType.HORIZONTAL && (side == dir.m_122427_() && !type.isRight() || side == dir.m_122428_() && type.isRight())) {
            Direction face = type.isTop() == adjTop ? adjDir : adjDir.m_122424_();
            return (type.isTop() == adjTop && adjDir == dir || type.isTop() != adjTop && adjDir == dir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, face);
        }
        return false;
    }

    private boolean testAgainstThreewaySlope(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (!(type.isHorizontal() || adjDir != dir || adjTop != type.isTop() || side != dir.m_122427_() && side != dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (type.isHorizontal() && (!type.isRight() && adjDir == dir || type.isRight() && adjDir == dir.m_122427_()) && adjTop == type.isTop() && (side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop() || side == dir.m_122427_() && !type.isRight() || side == dir.m_122428_() && type.isRight())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstInnerThreewaySlope(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (!type.isHorizontal() && adjTop == type.isTop() && (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (type.isHorizontal()) {
            if (adjTop != type.isTop() && (adjDir == dir && !type.isRight() || adjDir == dir.m_122427_() && type.isRight()) && (!type.isTop() && side == Direction.UP || type.isTop() && side == Direction.DOWN)) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (adjTop == type.isTop() && (!type.isRight() && side == dir.m_122427_() && adjDir == dir.m_122427_() || type.isRight() && side == dir.m_122428_() && adjDir == dir)) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        }
        return false;
    }

    private boolean testAgainstDoubleThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (!type.isHorizontal()) {
            if (adjTop == type.isTop() && (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
                return SideSkipPredicate.compareState(level, pos, side, adjTop ? Direction.UP : Direction.DOWN);
            }
            if (adjTop != type.isTop() && adjDir == dir.m_122424_() && (side == dir.m_122427_() || side == dir.m_122424_())) {
                return SideSkipPredicate.compareState(level, pos, side, type.isTop() ? Direction.UP : Direction.DOWN);
            }
        } else {
            if (adjTop == type.isTop() && (side == dir.m_122428_() && adjDir == dir && type.isRight() || side == dir.m_122427_() && adjDir == dir.m_122427_() && !type.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (adjTop != type.isTop() && (side == dir.m_122427_() && adjDir == dir.m_122424_() && !type.isRight() || side == dir.m_122428_() && adjDir == dir.m_122428_() && type.isRight())) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (adjTop != type.isTop() && (side == Direction.UP && !type.isTop() || side == Direction.DOWN && type.isTop()) && (!type.isRight() && (adjDir == dir || adjDir == dir.m_122424_()) || type.isRight() && (adjDir == dir.m_122427_() || adjDir == dir.m_122428_()))) {
                return SideSkipPredicate.compareState(level, pos, side, dir);
            }
        }
        return false;
    }
}

