/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class InnerThreewayCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Block block = adjState.m_60734_();
        if (!(block instanceof IFramedBlock)) {
            return false;
        }
        IFramedBlock block2 = (IFramedBlock)block;
        BlockType adjBlock = block2.getBlockType();
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        if (adjBlock == BlockType.FRAMED_INNER_PRISM_CORNER || adjBlock == BlockType.FRAMED_INNER_THREEWAY_CORNER) {
            return this.testAgainstInnerThreewayCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_PRISM_CORNER || adjBlock == BlockType.FRAMED_THREEWAY_CORNER) {
            return this.testAgainstThreewayCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_PRISM_CORNER || adjBlock == BlockType.FRAMED_DOUBLE_THREEWAY_CORNER) {
            return this.testAgainstDoubleThreewayCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_SLOPE) {
            return this.testAgainstSlope(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_SLOPE) {
            return this.testAgainstDoubleSlope(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_CORNER_SLOPE) {
            return this.testAgainstCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_INNER_CORNER_SLOPE) {
            return this.testAgainstInnerCorner(level, pos, dir, top, adjState, side);
        }
        if (adjBlock == BlockType.FRAMED_DOUBLE_CORNER) {
            return this.testAgainstDoubleCorner(level, pos, dir, top, adjState, side);
        }
        return false;
    }

    private boolean testAgainstInnerThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (adjTop == top && (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjTop != top && adjDir == dir && (side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (adjTop == top && adjDir == dir && (side == dir.m_122427_() || side == dir.m_122424_() || side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(level, pos, side, adjDir);
        }
        return false;
    }

    private boolean testAgainstDoubleThreewayCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (adjTop == top && (side == dir.m_122424_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        if (adjTop != top && adjDir == dir && (side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(level, pos, side, top ? Direction.DOWN : Direction.UP);
        }
        if (adjTop != top && adjDir == dir.m_122424_() && (side == dir.m_122424_() || side == dir.m_122427_() || side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
        }
        return false;
    }

    private boolean testAgainstSlope(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (adjType != SlopeType.HORIZONTAL && (side == dir.m_122427_() && adjDir == dir || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
            return adjType == SlopeType.TOP == top && SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjType == SlopeType.HORIZONTAL && adjDir == dir && (side == Direction.UP && !top || side == Direction.DOWN && top)) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoubleSlope(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (adjType != SlopeType.HORIZONTAL) {
            if (adjDir == dir && adjType == SlopeType.TOP == top || adjDir == dir.m_122424_() && adjType == SlopeType.TOP != top) {
                return side == dir.m_122427_() && SideSkipPredicate.compareState(level, pos, side, dir);
            }
            if (adjDir == dir.m_122428_() && adjType == SlopeType.TOP == top || adjDir == dir.m_122427_() && adjType == SlopeType.TOP != top) {
                return side == dir.m_122424_() && SideSkipPredicate.compareState(level, pos, side, dir.m_122428_());
            }
        } else if (adjDir == dir || adjDir == dir.m_122424_()) {
            return (side == Direction.UP && !top || side == Direction.DOWN && top) && SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!(adjType.isHorizontal() || adjType.isTop() != top || adjDir != dir || side != dir.m_122427_() && side != dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjType.isHorizontal() && (side == Direction.UP && !top || side == Direction.DOWN && top) && (adjDir == dir && !adjType.isRight() || adjDir == dir.m_122428_() && adjType.isRight())) {
            return adjType.isTop() == top && SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjType.isHorizontal() && (side == dir.m_122427_() && adjDir == dir && !adjType.isRight() || side == dir.m_122424_() && adjDir == dir.m_122428_() && adjType.isRight())) {
            return adjType.isTop() == top && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstInnerCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!adjType.isHorizontal() && adjType.isTop() == top && (side == dir.m_122427_() && adjDir == dir.m_122427_() || side == dir.m_122424_() && adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjType.isHorizontal() && adjType.isTop() != top && (side == Direction.UP && !top || side == Direction.DOWN && top) && (adjDir == dir && !adjType.isRight() || adjDir == dir.m_122428_() && adjType.isRight())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (adjType.isHorizontal() && adjType.isTop() == top && (side == dir.m_122427_() && adjDir == dir && adjType.isRight() || side == dir.m_122424_() && adjDir == dir.m_122428_() && !adjType.isRight())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoubleCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (!adjType.isHorizontal()) {
            if (adjType.isTop() == top && (side == dir.m_122424_() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjDir == dir.m_122427_())) {
                return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
            }
            if (adjType.isTop() != top && (side == dir.m_122424_() && adjDir == dir.m_122424_() || side == dir.m_122427_() && adjDir == dir.m_122424_())) {
                return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
            }
        } else if (adjType.isTop() != top && (side == Direction.UP && !top || side == Direction.DOWN && top)) {
            if (adjDir == dir && !adjType.isRight() || adjDir == dir.m_122428_() && adjType.isRight()) {
                return SideSkipPredicate.compareState(level, pos, side, adjDir);
            }
            if (adjDir == dir.m_122424_() && !adjType.isRight() || adjDir == dir.m_122427_() && adjType.isRight()) {
                return SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
            }
        } else {
            if (adjType.isTop() == top && (side == dir.m_122424_() && !adjType.isRight() && adjDir == dir.m_122428_() || side == dir.m_122427_() && adjType.isRight() && adjDir == dir)) {
                return SideSkipPredicate.compareState(level, pos, side, adjDir);
            }
            if (adjType.isTop() != top && (side == dir.m_122427_() && !adjType.isRight() && adjDir == dir.m_122424_() || side == dir.m_122424_() && adjType.isRight() && adjDir == dir.m_122427_())) {
                return SideSkipPredicate.compareState(level, pos, side, adjDir.m_122424_());
            }
        }
        return false;
    }
}

