/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class PanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedPanel.get()) {
            return this.testAgainstPanel(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoublePanel.get()) {
            return this.testAgainstDoublePanel(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedCornerPillar.get()) {
            return this.testAgainstPillar(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get()) {
            return this.testAgainstEdge(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return this.testAgainstStairs(level, pos, dir, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedVerticalStairs.get()) {
            return this.testAgainstVerticalStairs(level, pos, dir, adjState, side);
        }
        return false;
    }

    private boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side == dir.m_122424_()) {
            return false;
        }
        return dir == adjState.m_61143_((Property)PropertyHolder.FACING_HOR) && SideSkipPredicate.compareState(level, pos, side, dir);
    }

    private boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side == dir.m_122424_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        return (dir == adjDir || dir == adjDir.m_122424_()) && SideSkipPredicate.compareState(level, pos, side, dir);
    }

    private boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (adjDir != dir) {
            return false;
        }
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == Direction.UP && !adjTop || side == Direction.DOWN && adjTop) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        boolean adjTop;
        if (side.m_122434_() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && adjTop || side == Direction.DOWN && !adjTop) {
            return adjShape == StairsShape.STRAIGHT && SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return adjType == StairsType.VERTICAL && SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }
}

