/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class SlabEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get()) {
            return this.testAgainstEdge(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlab.get()) {
            return this.testAgainstSlab(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoubleSlab.get()) {
            return this.testAgainstDoubleSlab(level, pos, dir, top, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabCorner.get()) {
            return this.testAgainstCorner(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedPanel.get()) {
            return this.testAgainstPanel(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoublePanel.get()) {
            return this.testAgainstDoublePanel(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return this.testAgainstStairs(level, pos, dir, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedVerticalStairs.get()) {
            return this.testAgainstVerticalStairs(level, pos, dir, top, adjState, side);
        }
        return false;
    }

    private boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == dir && adjDir == side.m_122424_()) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122427_() || side == dir.m_122428_()) {
            return dir == adjDir && top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        if (side.m_122434_() == Direction.Axis.Y && dir == adjDir) {
            return top != adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side != dir || top != (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side);
    }

    private boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, boolean top, Direction side) {
        if (side != dir) {
            return false;
        }
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, face);
    }

    private boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side.m_122434_() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        if (side.m_122434_() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        if (dir != adjDir && dir != adjDir.m_122424_()) {
            return false;
        }
        if (side == Direction.UP && top || side == Direction.DOWN && !top) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (top && side == Direction.UP || !top && side == Direction.DOWN) {
            if (adjShape != StairsShape.STRAIGHT || dir != adjDir) {
                return false;
            }
            return top == adjTop && SideSkipPredicate.compareState(level, pos, side);
        }
        if (top == adjTop && side == dir && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL) {
            return false;
        }
        if (side == dir.m_122428_() && adjDir == dir || side == dir.m_122427_() && adjDir == dir.m_122427_()) {
            return top != adjType.isTop() && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }
}

