/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.StairsSkipPredicate;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class SlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (side.m_122434_() == Direction.Axis.Y) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        boolean top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        if (adjState.m_60734_() == FBContent.blockFramedSlab.get()) {
            return this.testAgainstSlab(level, pos, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoubleSlab.get()) {
            return this.testAgainstDoubleSlab(level, pos, top, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get()) {
            return this.testAgainstEdge(level, pos, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return this.testAgainstStairs(level, pos, top, adjState, side);
        }
        return false;
    }

    private boolean testAgainstSlab(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, boolean top, Direction side) {
        Direction face = top ? Direction.UP : Direction.DOWN;
        return SideSkipPredicate.compareState(level, pos, side, face);
    }

    private boolean testAgainstEdge(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        if (top != (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP)) {
            return false;
        }
        if (adjState.m_61143_((Property)PropertyHolder.FACING_HOR) != side.m_122424_()) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private boolean testAgainstStairs(BlockGetter level, BlockPos pos, boolean top, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (top == adjTop && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }
}

