/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import uk.joshiejack.penguinlib.client.PenguinClientConfig;
import uk.joshiejack.penguinlib.data.LootTableMerger;
import uk.joshiejack.penguinlib.data.PenguinRegistries;
import uk.joshiejack.penguinlib.data.custom.CustomObject;
import uk.joshiejack.penguinlib.data.generators.PenguinBlockTags;
import uk.joshiejack.penguinlib.data.generators.PenguinDatabase;
import uk.joshiejack.penguinlib.data.generators.PenguinItemModels;
import uk.joshiejack.penguinlib.data.generators.PenguinItemTags;
import uk.joshiejack.penguinlib.data.generators.PenguinLanguage;
import uk.joshiejack.penguinlib.data.generators.PenguinRecipes;
import uk.joshiejack.penguinlib.events.CollectRegistryEvent;
import uk.joshiejack.penguinlib.item.PenguinItems;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.util.PenguinLoader;
import uk.joshiejack.penguinlib.util.helpers.generic.ReflectionHelper;
import uk.joshiejack.penguinlib.util.interfaces.IModPlugin;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="penguinlib")
public class PenguinLib {
    public static final String MODID = "penguinlib";
    public static final IEventBus EVENT_BUS = BusBuilder.builder().build();
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Type LOADER = Type.getType(PenguinLoader.class);
    private static final Type PACKET = Type.getType(PenguinLoader.Packet.class);
    public static final ItemGroup TAB = new ItemGroup("penguinlib"){

        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)PenguinItems.JAM_JAR.get());
        }
    };

    public PenguinLib() {
        EVENT_BUS.register((Object)this);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        HashMap processors = new HashMap();
        processors.put(CustomObject.Data.class, (data, string) -> {
            CustomObject.Data cfr_ignored_0 = (CustomObject.Data)CustomObject.TYPE_REGISTRY.put(string, (Object)((CustomObject.Data)Objects.requireNonNull(ReflectionHelper.newInstance(data))));
        });
        this.registerPenguinLoaderData(processors);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PenguinItems.ITEMS.register(eventBus);
        LootTableMerger.LOOT_MODIFIER_SERIALIZERS.register(eventBus);
        PenguinRegistries.SERIALIZERS.register(eventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, PenguinClientConfig.create());
    }

    private void setup(FMLCommonSetupEvent event) {
        ArrayList plugins = new ArrayList();
        HashMap processors = new HashMap();
        processors.put(IModPlugin.class, (data, string) -> plugins.add(Pair.of((Object)string, (Object)data)));
        FMLJavaModLoadingContext.get().getModEventBus().post((Event)new CollectRegistryEvent.Loader(processors));
        this.registerPenguinLoaderData(processors);
        plugins.stream().filter(pair -> ModList.get().isLoaded((String)pair.getKey())).forEach(pair -> ((IModPlugin)Objects.requireNonNull(ReflectionHelper.newInstance((Class)pair.getValue()))).setup());
        plugins.clear();
    }

    @SubscribeEvent
    public static void onDataGathering(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new PenguinDatabase(generator));
            PenguinBlockTags blockTags = new PenguinBlockTags(generator, event.getExistingFileHelper());
            generator.func_200390_a((IDataProvider)blockTags);
            generator.func_200390_a((IDataProvider)new PenguinItemTags(generator, blockTags, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new PenguinRecipes(generator));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new PenguinLanguage(generator));
            generator.func_200390_a((IDataProvider)new PenguinItemModels(generator, event.getExistingFileHelper()));
        }
    }

    private void registerPenguinLoaderData(Map<Class<?>, BiConsumer<Class<?>, String>> processors) {
        ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> LOADER.equals((Object)a.getAnnotationType()) || PACKET.equals((Object)a.getAnnotationType())).forEach(a -> {
            try {
                Class<?> clazz = Class.forName(a.getClassType().getClassName());
                if (PenguinPacket.class.isAssignableFrom(clazz)) {
                    PenguinNetwork.registerPacket(clazz, NetworkDirection.valueOf((String)((ModAnnotation.EnumHolder)a.getAnnotationData().get("value")).getValue()));
                } else {
                    processors.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(clazz)).forEach(entry -> ((BiConsumer)entry.getValue()).accept(clazz, (String)a.getAnnotationData().get("value")));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
    }
}

