/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.block.base;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.block.base.AbstractRotatableBlock;

public abstract class AbstractDoubleBlock
extends AbstractRotatableBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;

    public AbstractDoubleBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult blockRayTraceResult) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return super.func_225533_a_(world.func_180495_p(pos.func_177977_b()), world, pos.func_177977_b(), player, hand, blockRayTraceResult);
        }
        return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState oldState, Direction direction, @Nonnull BlockState newState, @Nonnull IWorld world, @Nonnull BlockPos oldPos, @Nonnull BlockPos newPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)oldState.func_177229_b(HALF);
        if (direction.func_176740_k() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return newState.func_203425_a((Block)this) && newState.func_177229_b(HALF) != doubleblockhalf ? (BlockState)oldState.func_206870_a((Property)FACING, newState.func_177229_b((Property)FACING)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !oldState.func_196955_c((IWorldReader)world, oldPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(oldState, direction, newState, world, oldPos, newPos);
    }

    public void func_176208_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player) {
        if (!world.field_72995_K && player.func_184812_l_()) {
            AbstractDoubleBlock.preventCreativeDropFromBottomPart(world, pos, state, player);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180657_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable TileEntity tile, @Nonnull ItemStack stack) {
        super.func_180657_a(world, player, pos, Blocks.field_150350_a.func_176223_P(), tile, stack);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext ctx) {
        BlockPos blockpos = ctx.func_195995_a();
        if (blockpos.func_177956_o() < 255 && ctx.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(ctx)) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f())).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity entity, @Nonnull ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean func_196260_a(@Nonnull BlockState state, @Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = world.func_180495_p(blockpos);
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER || blockstate.func_203425_a((Block)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(@Nonnull BlockState state, @Nonnull BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }

    @Override
    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF, FACING});
    }

    private static void preventCreativeDropFromBottomPart(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
    }
}

