/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Chatter {
    private TextFormatting formatting = TextFormatting.BOLD;
    private final ITextComponent unlocalized;
    private int maxLines = 4;
    private int maxWidth = 171;
    private int height = 10;
    private String[][] script;
    private char[] fordisplay;
    private int page;
    private int line;
    private double character;
    private boolean finished;
    private long previous;
    private boolean isScriptInit;
    private boolean isInstant;
    private long start;

    public Chatter(ITextComponent text) {
        this.unlocalized = text;
    }

    public Chatter setInstant() {
        this.isInstant = true;
        return this;
    }

    public Chatter withHeight(int height) {
        this.height = height;
        return this;
    }

    public Chatter withFormatting(@Nullable TextFormatting formatting) {
        this.formatting = formatting;
        return this;
    }

    public Chatter withLines(int lines) {
        this.maxLines = lines;
        return this;
    }

    public Chatter withWidth(int width) {
        this.maxWidth = width;
        return this;
    }

    private static String modify(String text) {
        String localized = new TranslationTextComponent(text).getString();
        if (!localized.equals(text)) {
            return localized;
        }
        return text;
    }

    public static String modify(ITextComponent text, String ... formatting) {
        if (formatting.length > 0) {
            String[] adjusted = new String[formatting.length];
            for (int i = 0; i < adjusted.length; ++i) {
                adjusted[i] = Chatter.modify(formatting[i]);
            }
            return String.format(text.getString(), adjusted);
        }
        return new TranslationTextComponent(text.getString()).getString();
    }

    public void update(FontRenderer fontRenderer, String ... formatting) {
        if (!this.isScriptInit) {
            this.isScriptInit = true;
            this.script = this.buildScript(fontRenderer, Chatter.modify(this.unlocalized, formatting));
            this.start = System.currentTimeMillis();
        }
        if (this.isInstant) {
            this.line = this.maxLines;
        }
        if (this.script == null) {
            return;
        }
        if (!this.finished && this.line >= 2) {
            this.finished = true;
        }
        long current = System.currentTimeMillis();
        if (this.line < this.maxLines) {
            if (this.script[this.page][this.line] != null) {
                char[] todisplay = this.script[this.page][this.line].toCharArray();
                if (todisplay.length > 0) {
                    if (("" + todisplay[0]).equals("@")) {
                        this.character = todisplay.length;
                    }
                    if (this.character < (double)todisplay.length && (double)(current - this.previous) > 1.9) {
                        this.character += 0.2;
                    }
                }
                this.fordisplay = new char[(int)Math.ceil(this.character)];
                for (int i = 0; i < this.fordisplay.length; ++i) {
                    if (i >= todisplay.length) continue;
                    this.fordisplay[i] = todisplay[i];
                }
                if (this.fordisplay.length >= todisplay.length) {
                    this.character = 0.0;
                    ++this.line;
                }
            } else {
                this.finished = true;
            }
        }
        this.previous = current;
    }

    public void draw(MatrixStack matrix, FontRenderer fontRenderer, int x, int y, int color) {
        if (!this.isScriptInit) {
            return;
        }
        for (int i = 0; i < this.line; ++i) {
            String text = this.script[this.page][i];
            if (text == null) continue;
            if (this.formatting == null) {
                fontRenderer.func_238421_b_(matrix, text, (float)x, (float)(y + i * this.height), color);
                continue;
            }
            fontRenderer.func_238421_b_(matrix, this.formatting + text, (float)x, (float)(y + i * this.height), color);
        }
        if (this.line < this.maxLines && this.fordisplay != null) {
            if (this.script[this.page][this.line] != null) {
                if (this.formatting == null) {
                    fontRenderer.func_238421_b_(matrix, new String(this.fordisplay), (float)x, (float)(y + this.line * this.height), color);
                } else {
                    fontRenderer.func_238421_b_(matrix, this.formatting + new String(this.fordisplay), (float)x, (float)(y + this.line * this.height), color);
                }
            } else {
                this.finished = true;
            }
        }
    }

    private String[][] buildScript(FontRenderer fontRenderer, String text) {
        boolean isRemainder;
        List formatted = fontRenderer.func_238420_b_().func_238365_g_(text, this.maxWidth, Style.field_240709_b_);
        String[] original = (String[])formatted.stream().map(ITextProperties::getString).toArray(String[]::new);
        int size = original.length / this.maxLines;
        boolean bl = isRemainder = original.length % this.maxLines == 0;
        if (!isRemainder) {
            ++size;
        }
        int start = 0;
        String[][] script = new String[size][this.maxLines];
        for (int i = 0; i < size; ++i) {
            int length = Math.min(start + this.maxLines, original.length);
            String[] subtext = Arrays.copyOfRange(original, start, length);
            System.arraycopy(subtext, 0, script[i], 0, subtext.length);
            start += this.maxLines;
        }
        return script;
    }

    public int getPage() {
        return this.page;
    }

    public int getMaxPage() {
        return this.script.length - 1;
    }

    private boolean previousChat() {
        if (!this.finished) {
            this.finished = true;
            this.line = this.maxLines;
        } else if (this.page > 0) {
            this.finished = false;
            --this.page;
        }
        return false;
    }

    private boolean nextChat() {
        if (!this.finished) {
            this.finished = true;
            this.line = this.maxLines;
            return false;
        }
        if (this.page < this.script.length - 1) {
            this.finished = false;
            this.line = 0;
            ++this.page;
            return false;
        }
        return true;
    }

    public boolean mouseClicked(int mouseButton) {
        return mouseButton == 0 && this.nextChat() || mouseButton == 1 && this.previousChat();
    }
}

