/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import uk.joshiejack.penguinlib.client.PenguinClientConfig;
import uk.joshiejack.penguinlib.util.helpers.minecraft.TimeHelper;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="penguinlib")
public class HUDRenderer {
    public static Object2ObjectMap<RegistryKey<World>, HUDRenderData> RENDERERS = new Object2ObjectOpenHashMap();

    private static String formatTime(int time) {
        int hour = time / 1000;
        int minute = (int)((double)(time % 1000) / 20.0 * 1.2);
        if (PenguinClientConfig.clockType.get() == PenguinClientConfig.ClockType.TWENTY_FOUR_HOUR) {
            return (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
        }
        boolean pm = false;
        if (hour > 12) {
            hour -= 12;
            pm = true;
        }
        if (hour == 12) {
            pm = true;
        }
        if (hour == 0) {
            hour = 12;
        }
        return (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute)) + (pm ? "PM" : "AM");
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        HUDRenderData hud;
        if (RENDERERS.size() == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && (hud = (HUDRenderData)RENDERERS.get((Object)mc.field_71441_e.func_234923_W_())) != null && hud.isEnabled()) {
            MatrixStack matrix = event.getMatrixStack();
            RenderSystem.enableBlend();
            int x = 0;
            int y = 0;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(hud.getTexture(mc));
            mc.field_71456_v.func_238474_b_(matrix, x - 44, y - 35, 0, 0, 256, 110);
            matrix.func_227860_a_();
            matrix.func_227862_a_(1.4f, 1.4f, 1.4f);
            ITextComponent header = hud.getHeader(mc);
            mc.field_71466_p.func_243246_a(matrix, header, (float)x / 1.4f + 30.0f, (float)y / 1.4f + 7.0f, -1);
            matrix.func_227865_b_();
            mc.field_71466_p.func_238405_a_(matrix, hud.getFooter(mc), (float)(x + 42), (float)(y + 23), -1);
            RenderSystem.disableBlend();
        }
    }

    public static abstract class HUDRenderData {
        public abstract boolean isEnabled();

        public abstract ResourceLocation getTexture(Minecraft var1);

        public abstract ITextComponent getHeader(Minecraft var1);

        public String getFooter(Minecraft mc) {
            String time = HUDRenderer.formatTime((int)TimeHelper.getTimeOfDay(mc.field_71441_e.func_72820_D()));
            return "(" + TimeHelper.shortName(TimeHelper.getWeekday(mc.field_71441_e.func_72820_D())) + ")  " + time;
        }
    }
}

