/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.client.gui.book.page;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.client.gui.book.Book;
import uk.joshiejack.penguinlib.client.gui.book.page.AbstractPage;
import uk.joshiejack.penguinlib.client.gui.book.widget.ArrowButton;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractMultiPage<P>
extends AbstractPage {
    protected List<P> entries = new ArrayList<P>();
    protected final int perPage;
    protected int page;

    public AbstractMultiPage(ITextComponent name, int perPage) {
        super(name);
        this.perPage = perPage;
    }

    public void back(Book book) {
        --this.page;
        book.func_231158_b_(book.minecraft(), book.field_230708_k_, book.field_230709_l_);
    }

    public void forward(Book book) {
        ++this.page;
        book.func_231158_b_(book.minecraft(), book.field_230708_k_, book.field_230709_l_);
    }

    protected abstract void initEntry(Book var1, int var2, int var3, int var4, P var5);

    protected abstract List<P> getEntries();

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Both<P>
    extends AbstractMultiPage<P> {
        public Both(ITextComponent name, int perPage) {
            super(name, perPage);
        }

        @Override
        public void initLeft(Book book, int left, int top) {
            this.entries = this.getEntries();
            if (this.page != 0) {
                book.func_230480_a_(new ArrowButton.Left(book, left + 20, top + 154, button -> this.back(book)));
            }
            for (int i = 0; i < this.perPage / 2; ++i) {
                int id = this.page * this.perPage + i;
                if (id >= this.entries.size()) continue;
                this.initEntry(book, left + 2, top, i, this.entries.get(id));
            }
        }

        @Override
        public void initRight(Book book, int left, int top) {
            int maxPage = Math.max(0, (int)Math.ceil((double)this.entries.size() / (double)this.perPage) - 1);
            if (this.page != maxPage) {
                book.func_230480_a_(new ArrowButton.Right(book, left + 119, top + 154, button -> this.forward(book)));
            }
            for (int i = this.perPage / 2; i < this.perPage; ++i) {
                int id = this.page * this.perPage + i;
                if (id >= this.entries.size()) continue;
                this.initEntry(book, left - 8, top, i - this.perPage / 2, this.entries.get(id));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Right<P>
    extends AbstractMultiPage<P> {
        public Right(ITextComponent name, int perPage) {
            super(name, perPage);
        }

        @Override
        public void initLeft(Book book, int left, int top) {
        }

        @Override
        public void initRight(Book book, int left, int top) {
            if (this.page != 0) {
                book.func_230480_a_(new ArrowButton.Left(book, left + 10, top + 154, button -> this.back(book)));
            }
            this.entries = this.getEntries();
            int maxPage = Math.max(0, (int)Math.ceil((double)this.entries.size() / (double)this.perPage) - 1);
            if (this.page != maxPage) {
                book.func_230480_a_(new ArrowButton.Right(book, left + 119, top + 154, button -> this.forward(book)));
            }
            for (int i = 0; i < this.perPage; ++i) {
                int id = this.page * this.perPage + i;
                if (id >= this.entries.size()) continue;
                this.initEntry(book, left, top, i, this.entries.get(id));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Left<P>
    extends AbstractMultiPage<P> {
        public Left(ITextComponent name, int perPage) {
            super(name, perPage);
        }

        @Override
        public void initLeft(Book book, int left, int top) {
            if (this.page != 0) {
                book.func_230480_a_(new ArrowButton.Left(book, left + 20, top + 154, button -> this.back(book)));
            }
            this.entries = this.getEntries();
            int maxPage = Math.max(0, (int)Math.ceil((double)this.entries.size() / (double)this.perPage) - 1);
            if (this.page != maxPage) {
                book.func_230480_a_(new ArrowButton.Right(book, left + 130, top + 154, button -> this.forward(book)));
            }
            for (int i = 0; i < this.perPage; ++i) {
                int id = this.page * this.perPage + i;
                if (id >= this.entries.size()) continue;
                this.initEntry(book, left, top, i, this.entries.get(id));
            }
        }

        @Override
        public void initRight(Book book, int left, int top) {
        }
    }
}

