/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.client.gui.book.tab;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.client.gui.book.Book;
import uk.joshiejack.penguinlib.client.gui.book.page.AbstractPage;
import uk.joshiejack.penguinlib.client.gui.book.widget.TabButton;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;

@OnlyIn(value=Dist.CLIENT)
public class Tab {
    public static final ITextComponent EMPTY_STRING = new StringTextComponent("");
    public static final Tab EMPTY = new Tab(EMPTY_STRING, ItemIcon.EMPTY);
    private final List<AbstractPage> pages = new ArrayList<AbstractPage>();
    private final ITextComponent name;
    private final Icon icon;
    private AbstractPage defaultPage = AbstractPage.EMPTY;
    protected AbstractPage page;

    public Tab(ITextComponent name, Icon icon) {
        this.name = name;
        this.icon = icon;
    }

    protected List<AbstractPage> getPages() {
        return this.pages;
    }

    public Tab withPage(AbstractPage page) {
        if (!this.pages.contains(page)) {
            this.pages.add(page);
        }
        if (this.defaultPage == AbstractPage.EMPTY) {
            this.defaultPage = page;
        }
        return this;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    public AbstractPage getPage() {
        if (this.page == null) {
            this.page = this.defaultPage;
        }
        return this.page;
    }

    public void setPage(AbstractPage page) {
        this.page = page;
    }

    protected Button.ITooltip createTooltip(Book book, ITextComponent tooltip) {
        return (btn, mtx, mX, mY) -> book.func_238654_b_(mtx, book.minecraft().field_71466_p.func_238425_b_((ITextProperties)tooltip, Math.max(book.field_230708_k_ / 2 - 43, 170)), mX, mY);
    }

    public AbstractButton create(Book book, int x, int y) {
        return new TabButton.Left(book, this.getIcon(), x, y, this.name, btn -> {
            if (this.page == null) {
                this.page = this.defaultPage;
            }
            book.setTab(this);
        }, this.createTooltip(book, this.name), book.isSelected(this));
    }

    public void addTabs(Book screen, int x, int y) {
        List<AbstractPage> pages = this.getPages();
        if (pages.size() > 1) {
            int i = 0;
            for (AbstractPage page : pages) {
                screen.func_230480_a_(page.createTab(screen, this, x, y + i++ * 36));
            }
        }
    }
}

