/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.custom;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.IOUtils;
import uk.joshiejack.penguinlib.PenguinLib;
import uk.joshiejack.penguinlib.data.custom.CustomObject;
import uk.joshiejack.penguinlib.data.custom.PenguinGson;

@Mod.EventBusSubscriber(modid="penguinlib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CustomLoader {
    private static final int PATH_SUFFIX_LENGTH = ".json".length();

    private static void register(CustomObject co) {
        ((CustomObject.Data)CustomObject.TYPE_REGISTRY.get((Object)co.type)).register(co.name, co.data);
    }

    public static <I extends CustomObject> List<I> loadJson(IResourceManager rm, String dir) {
        ArrayList<CustomObject> list = new ArrayList<CustomObject>();
        for (ResourceLocation rl : rm.func_199003_a(dir, fileName -> fileName.endsWith(".json"))) {
            try {
                IResource resource = rm.func_199002_a(rl);
                InputStream is = resource.func_199027_b();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                CustomObject i = (CustomObject)PenguinGson.get().fromJson(IOUtils.toString((Reader)reader), CustomObject.class);
                if (i != null) {
                    list.add(i);
                    continue;
                }
                PenguinLib.LOGGER.error("FAILED TO LOAD " + rl);
            }
            catch (IOException | IllegalArgumentException ex) {
                PenguinLib.LOGGER.error("Couldn't kill data file from {}", (Object)rl, (Object)ex);
            }
        }
        return list;
    }
}

