/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.custom;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import uk.joshiejack.penguinlib.data.custom.CustomObject;
import uk.joshiejack.penguinlib.data.custom.PenguinGson;

public abstract class CustomObjectProvider
implements IDataProvider {
    private final Map<String, Map<String, CustomObject>> data = new HashMap<String, Map<String, CustomObject>>();
    private final DataGenerator gen;
    private final String modid;

    public CustomObjectProvider(DataGenerator gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    protected void addEntry(String file, String subdir, String type, String name, CustomObject.Data<?> data) {
        HashMap<String, CustomObject> map = this.data.containsKey(subdir) ? this.data.get(subdir) : new HashMap<String, CustomObject>();
        map.put(file, new CustomObject(type, name, data));
        this.data.put(subdir, map);
    }

    protected abstract void addCustomObjectEntries();

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addCustomObjectEntries();
        if (!this.data.isEmpty()) {
            for (String subdir : this.data.keySet()) {
                for (String file : this.data.get(subdir).keySet()) {
                    this.save(cache, this.data.get(subdir).get(file), this.gen.func_200391_b().resolve("data/" + this.modid + "/custom/" + subdir + "/" + file + ".json"));
                }
            }
        }
    }

    private void save(DirectoryCache cache, CustomObject object, Path target) throws IOException {
        String data = PenguinGson.get().toJson((Object)object);
        String hash = IDataProvider.field_208307_a.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.func_208323_a(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.func_208316_a(target, hash);
    }

    @Nonnull
    public String func_200397_b() {
        return "Custom Objects";
    }
}

