/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.custom;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import uk.joshiejack.penguinlib.data.adapters.CustomObjectAdapter;
import uk.joshiejack.penguinlib.data.adapters.ResourceLocationAdapter;
import uk.joshiejack.penguinlib.data.custom.CustomObject;

public class PenguinGson {
    private static Gson gson;

    public static Gson get() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().setExclusionStrategies(new ExclusionStrategy[]{new SuperClassExclusionStrategy()});
            builder.registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationAdapter());
            builder.registerTypeAdapter(CustomObject.class, (Object)new CustomObjectAdapter());
            gson = builder.create();
        }
        return gson;
    }

    private static class SuperClassExclusionStrategy
    implements ExclusionStrategy {
        private SuperClassExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getDeclaringClass().equals(ForgeRegistryEntry.class);
        }
    }
}

