/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.database;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.joshiejack.penguinlib.client.PenguinClientConfig;
import uk.joshiejack.penguinlib.data.PenguinRegistries;
import uk.joshiejack.penguinlib.data.database.CSVUtils;
import uk.joshiejack.penguinlib.data.database.Table;
import uk.joshiejack.penguinlib.events.DatabaseLoadedEvent;
import uk.joshiejack.penguinlib.events.DatabasePopulateEvent;
import uk.joshiejack.penguinlib.item.crafting.SimplePenguinRecipe;

@Mod.EventBusSubscriber(modid="penguinlib")
public class Database
extends ReloadListener<Map<String, Table>> {
    public static final Database INSTANCE = new Database();
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int pathSuffixLength = ".csv".length();
    private static final String directory = "database";
    private static final int dirLength = "database".length() + 1;
    private final Map<String, String> tableData = new HashMap<String, String>();

    public static void print(Map<String, Table> tables) {
        for (String table : tables.keySet()) {
            LOGGER.info("############## TABLE: " + table + " ##############");
            LOGGER.info(tables.get(table).labelset());
            tables.get(table).rows().forEach(r -> {
                ArrayList arr = new ArrayList();
                ((Table)tables.get(table)).labels().forEach(header -> arr.add(r.get((String)header)));
                LOGGER.info(Arrays.toString(arr.toArray()));
            });
        }
    }

    @SubscribeEvent
    public static void registerData(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new Database());
    }

    @Nonnull
    public <T> T get(Map<String, Table> tables, String search) {
        String[] terms = search.split(",");
        String table = terms[0].trim();
        String row = terms[1].trim();
        String data = terms[2].trim();
        Preconditions.checkNotNull((Object)table, (Object)("The table cannot be null: " + table));
        Preconditions.checkNotNull((Object)row, (Object)("The id to search in the table cannot be null: " + row));
        Preconditions.checkNotNull((Object)data, (Object)("The instance you are searching for cannot be null: " + data));
        return tables.getOrDefault(table, Table.EMPTY).find(row).get(data);
    }

    public static Table createTable(Map<String, Table> tables, String name, String ... labelset) {
        if (tables.containsKey(name)) {
            return tables.get(name);
        }
        Table table = new Table(name, labelset);
        tables.put(name, table);
        return table;
    }

    private static void parseCSV(Map<String, Table> tables, Map<String, String> tableData, String name, String csv) {
        String file_name = new File(name).getName();
        name = (file_name.startsWith("$") ? file_name.replace("$", "") : (file_name.contains("$") ? file_name.split("\\$")[1] : file_name)).toLowerCase(Locale.ROOT);
        tableData.put(name, csv);
        String[] entries = csv.split("[\\r\\n]+");
        String[] labels = entries[0].split(",");
        Table table = Database.createTable(tables, name, labels);
        for (int i = 1; i < entries.length; ++i) {
            List<String> list;
            if (entries[i].startsWith("#") || entries[i].isEmpty() || (list = CSVUtils.parse(entries[i])).isEmpty()) continue;
            try {
                table.insert(list.toArray(new String[0]));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                LOGGER.log(Level.ERROR, "Failed to insert the csv: " + name + " as there was an issue on line: " + i + " " + entries[i]);
            }
        }
    }

    private static void loadData(Map<String, Table> tables, IResourceManager rm, ResourceLocation rl) {
        String path = rl.func_110623_a();
        try {
            IResource resource = rm.func_199002_a(rl);
            InputStream is = resource.func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            Database.parseCSV(tables, Database.INSTANCE.tableData, path.substring(dirLength, path.length() - pathSuffixLength), IOUtils.toString((Reader)reader));
        }
        catch (IOException | IllegalArgumentException ex) {
            LOGGER.error("Couldn't parse data file from {}", (Object)rl, (Object)ex);
        }
    }

    public static Table loadTable(@Nonnull IResourceManager rm, String table) {
        HashMap tables = new HashMap();
        rm.func_199003_a(directory, fileName -> fileName.endsWith(table + ".csv")).forEach(rl -> Database.loadData(tables, rm, rl));
        return tables.getOrDefault(table, Table.EMPTY);
    }

    @Nonnull
    public Map<String, Table> prepare(@Nonnull IResourceManager rm, @Nonnull IProfiler profiler) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        this.tableData.clear();
        for (ResourceLocation rl : rm.func_199003_a(directory, fileName -> fileName.endsWith(".csv"))) {
            Database.loadData(tables, rm, rl);
        }
        return tables;
    }

    protected void apply(@Nonnull Map<String, Table> tables, @Nonnull IResourceManager rm, @Nonnull IProfiler profiler) {
        if (FMLEnvironment.dist == Dist.CLIENT && ((Boolean)PenguinClientConfig.enableDatabaseDebugger.get()).booleanValue()) {
            Database.print(tables);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DatabasePopulateEvent(tables));
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseLoadedEvent(tables));
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<Dummy> {
        @Nonnull
        public Dummy fromJson(@Nonnull ResourceLocation rl, @Nonnull JsonObject json) {
            return new Dummy();
        }

        @Nullable
        public Dummy fromNetwork(@Nonnull ResourceLocation rl, @Nonnull PacketBuffer packetbuffer) {
            HashMap<String, Table> tables = new HashMap<String, Table>();
            INSTANCE.tableData.clear();
            int tableCount = packetbuffer.readShort();
            for (int i = 0; i < tableCount; ++i) {
                String name = packetbuffer.func_218666_n();
                int parts = packetbuffer.readShort();
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j < parts; ++j) {
                    builder.append(packetbuffer.func_218666_n());
                }
                Database.parseCSV(tables, INSTANCE.tableData, name, builder.toString());
            }
            if (((Boolean)PenguinClientConfig.enableDatabaseDebugger.get()).booleanValue()) {
                Database.print(tables);
            }
            MinecraftForge.EVENT_BUS.post((Event)new DatabasePopulateEvent(tables));
            MinecraftForge.EVENT_BUS.post((Event)new DatabaseLoadedEvent(tables));
            return new Dummy();
        }

        public void toNetwork(@Nonnull PacketBuffer packetbuffer, @Nonnull Dummy dummy) {
            int tableCount = INSTANCE.tableData.size();
            packetbuffer.writeShort(tableCount);
            for (Map.Entry entry : INSTANCE.tableData.entrySet()) {
                packetbuffer.func_180714_a((String)entry.getKey());
                int parts = (int)Math.ceil((double)((String)entry.getValue()).length() / 32767.0);
                packetbuffer.writeShort(parts);
                for (int j = 0; j < parts; ++j) {
                    packetbuffer.func_180714_a(((String)entry.getValue()).substring(j * Short.MAX_VALUE, Math.min((j + 1) * Short.MAX_VALUE, ((String)entry.getValue()).length())));
                }
            }
        }
    }

    public static class Dummy
    extends SimplePenguinRecipe {
        public static final ResourceLocation ALL = new ResourceLocation("penguinlib", "all");

        public Dummy() {
            super(PenguinRegistries.DATABASE, (IRecipeSerializer)PenguinRegistries.DATABASE_SERIALIZER.get(), ALL, Ingredient.field_193370_a, ItemStack.field_190927_a);
        }
    }
}

