/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.database;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import uk.joshiejack.penguinlib.data.database.Row;

public class Table {
    public static final Table EMPTY = new Table("EMPTY", new String[0]);
    private final String name;
    private List<Row> data = new LinkedList<Row>();
    private String[] labelset;

    public Table(String name, String ... labelset) {
        this.name = name;
        this.labelset = new String[labelset.length];
        for (int i = 0; i < labelset.length; ++i) {
            this.labelset[i] = labelset[i].toLowerCase(Locale.ENGLISH);
        }
    }

    public void clear() {
        this.data.clear();
    }

    public List<String> labels() {
        return Arrays.stream(this.labelset).collect(Collectors.toList());
    }

    public Collection<Row> rows() {
        return this.data;
    }

    public void insert(Object ... dataset) {
        String[] data = new String[dataset.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = String.valueOf(dataset[i]);
        }
        this.insert(data);
    }

    public String labelset() {
        return Arrays.toString(this.labelset);
    }

    public void insert(String ... dataset) {
        this.data.add(new Row(this, this.labelset, dataset));
    }

    public Row find(String searchparameter) {
        return this.data.stream().filter(r -> r.contains(searchparameter)).findFirst().get();
    }

    public Row fetch_where(String query) {
        List<Row> ret = this.where(query);
        return ret.size() == 0 ? Row.EMPTY : ret.get(0);
    }

    public List<Row> where(String query) {
        if (query.equals("*")) {
            return this.data;
        }
        if (query.contains("&")) {
            String[] queries = query.split("&");
            return this.data.stream().filter(r -> {
                int match_count = 0;
                for (String s : queries) {
                    String field = s.split("=")[0];
                    String search = s.split("=")[1];
                    if (!r.get(field).equals(search)) continue;
                    ++match_count;
                }
                return match_count == queries.length;
            }).collect(Collectors.toList());
        }
        if (query.contains("|")) {
            String[] queries = query.split("\\|");
            return this.data.stream().filter(r -> {
                for (String s : queries) {
                    String field = s.split("=")[0];
                    String search = s.split("=")[1];
                    if (!r.get(field).equals(search)) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        String field = query.split("=")[0];
        String search = query.split("=")[1];
        return this.data.stream().filter(r -> r.get(field).equals(search)).collect(Collectors.toList());
    }

    public String name() {
        return this.name;
    }
}

