/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.data.generators;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import uk.joshiejack.penguinlib.data.TimeUnitRegistry;
import uk.joshiejack.penguinlib.data.database.CSVUtils;

public abstract class AbstractDatabaseProvider
implements IDataProvider {
    private final Multimap<String, String> data = LinkedHashMultimap.create();
    private final Map<String, String> headings = new HashMap<String, String>();
    private final DataGenerator gen;
    private final String modid;

    public AbstractDatabaseProvider(DataGenerator gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    public void addEntry(String file, String headings, String line) {
        this.headings.put(file, headings);
        this.data.get((Object)file).add(line);
    }

    protected void addFurnaceFuel(Item item, int burnTime) {
        this.addEntry("furnace_fuels", "Item,Burn Time", CSVUtils.join(item.getRegistryName().toString(), burnTime));
    }

    protected void addLootTableMerge(ResourceLocation target) {
        this.addEntry("merge_loot_table", "Target,Loot Table", CSVUtils.join(target, new ResourceLocation(this.modid, target.func_110623_a())));
    }

    protected void addTimeUnitForMachine(TileEntityType<?> type, TimeUnitRegistry.Defaults duration) {
        this.addTimeUnit(Objects.requireNonNull(type.getRegistryName()).toString(), duration.getValue());
    }

    protected void addTimeUnitForMachine(TileEntityType<?> type, long duration) {
        this.addTimeUnit(Objects.requireNonNull(type.getRegistryName()).toString(), duration);
    }

    protected void addTimeUnit(String name, long duration) {
        this.addEntry("time_unit", "Name,Duration", CSVUtils.join(name, duration));
    }

    protected abstract void addDatabaseEntries();

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.addDatabaseEntries();
        if (!this.data.isEmpty()) {
            for (String file : this.data.keySet()) {
                this.save(cache, this.headings.get(file), this.data.get((Object)file), this.gen.func_200391_b().resolve("data/" + this.modid + "/database/" + file + ".csv"));
            }
        }
    }

    private void save(DirectoryCache cache, String headings, Collection<String> strings, Path target) throws IOException {
        StringBuilder builder = new StringBuilder(headings);
        strings.forEach(s -> {
            builder.append("\n");
            builder.append((String)s);
        });
        String data = builder.toString();
        String hash = IDataProvider.field_208307_a.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.func_208323_a(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.func_208316_a(target, hash);
    }

    @Nonnull
    public String func_200397_b() {
        return "CSV Database";
    }
}

