/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.item.base;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public abstract class AbstractSickleItem
extends ToolItem {
    public static final ToolType SICKLE = ToolType.get((String)"sickle");
    protected static final Int2IntMap areaByHarvestLevel = new Int2IntOpenHashMap();
    private static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151585_k, (Object)Material.field_203243_f, (Object)Material.field_151582_l, (Object)Material.field_242934_h, (Object)Material.field_204868_h, (Object)Material.field_151584_j, (Object[])new Material[]{Material.field_215712_y, Material.field_215713_z, Material.field_151570_A});
    private static final Set<Block> EFFECTIVE_BLOCKS = new HashSet<Block>();

    public AbstractSickleItem(IItemTier tier, Item.Properties properties) {
        super(2.0f, -2.6f, tier, EFFECTIVE_BLOCKS, properties.addToolType(SICKLE, tier.func_200925_d()));
        areaByHarvestLevel.put(0, 0);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        float ret = super.func_150893_a(stack, state);
        return ret > 1.0f ? ret : (EFFECTIVE_MATERIALS.contains(state.func_185904_a()) ? this.field_77864_a : 1.0f);
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        if (!world.field_72995_K && state.func_185887_b((IBlockReader)world, pos) != 0.0f || EFFECTIVE_BLOCKS.contains(state.func_177230_c()) || EFFECTIVE_MATERIALS.contains(state.func_185904_a())) {
            stack.func_222118_a(1, entity, level -> level.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }
}

