/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.item.base;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class PenguinItem
extends Item {
    private final Supplier<ItemStack> result;
    private final UseAction useAction;
    private final int useDuration;
    private final BiConsumer<ItemStack, LivingEntity> finisher;

    public PenguinItem(Item.Properties properties) {
        super(properties);
        Properties pp = properties instanceof Properties ? (Properties)properties : null;
        this.useAction = pp == null ? UseAction.NONE : pp.useAction;
        this.useDuration = pp == null ? 0 : pp.useDuration;
        this.result = pp == null || pp.result == null ? null : pp.result;
        this.finisher = pp == null ? null : pp.consumer;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return stack.func_77973_b().func_219971_r() ? this.useDuration : 0;
    }

    @Nonnull
    public UseAction func_77661_b(@Nonnull ItemStack stack) {
        return stack.func_77973_b().func_219971_r() ? this.useAction : UseAction.NONE;
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull LivingEntity entity) {
        if (this.finisher != null) {
            this.finisher.accept(stack, entity);
        }
        if (this.result == null || !(entity instanceof PlayerEntity)) {
            return super.func_77654_b(stack, world, entity);
        }
        super.func_77654_b(stack, world, entity);
        if (stack.func_190926_b()) {
            return this.result.get();
        }
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)entity), (ItemStack)this.result.get());
        return stack;
    }

    public static class Properties
    extends Item.Properties {
        public BiConsumer<ItemStack, LivingEntity> consumer;
        private Supplier<ItemStack> result;
        private UseAction useAction = UseAction.EAT;
        private int useDuration = 32;

        public Properties useAction(UseAction useAction) {
            this.useAction = useAction;
            return this;
        }

        public Properties useDuration(int useDuration) {
            this.useDuration = useDuration;
            return this;
        }

        public Properties withContainer(Supplier<ItemStack> result) {
            this.result = result;
            return this;
        }

        public Properties finishUsing(BiConsumer<ItemStack, LivingEntity> consumer) {
            this.consumer = consumer;
            return this;
        }
    }
}

