/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.network;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.world.teams.PenguinTeam;
import uk.joshiejack.penguinlib.world.teams.PenguinTeams;

public class PenguinNetwork {
    private static final PenguinNetwork INSTANCE = new PenguinNetwork("penguinlib");
    private final SimpleChannel channel;
    private int id;

    private PenguinNetwork(String name) {
        Supplier<String> supplier = () -> "1";
        Predicate<String> predicate = s -> s.equals(supplier.get());
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(name, "main")).clientAcceptedVersions(predicate).serverAcceptedVersions(predicate).networkProtocolVersion(supplier).simpleChannel();
    }

    public static <MSG extends PenguinPacket> void registerPacket(Class<MSG> type, NetworkDirection direction) {
        Optional<NetworkDirection> optional = Optional.of(direction);
        PenguinNetwork.INSTANCE.channel.registerMessage(PenguinNetwork.INSTANCE.id++, type, PenguinPacket::encode, pb -> {
            PenguinPacket packet = null;
            try {
                packet = (PenguinPacket)type.newInstance();
                packet.decode((PacketBuffer)pb);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
            return packet;
        }, PenguinPacket::handle, optional);
    }

    public static void sendToClient(PenguinPacket packet, @Nullable ServerPlayerEntity player) {
        if (player != null) {
            PenguinNetwork.INSTANCE.channel.sendTo((Object)packet, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToTeam(PenguinPacket packet, ServerWorld world, UUID uuid) {
        PenguinTeam team = PenguinTeams.getTeamFromID(world, uuid);
        if (team != null) {
            team.members().stream().map(member -> world.func_217371_b(uuid)).filter(player -> player instanceof ServerPlayerEntity).map(player -> (ServerPlayerEntity)player).forEach(player -> PenguinNetwork.sendToClient(packet, player));
        }
    }

    public static void sendToServer(PenguinPacket packet) {
        PenguinNetwork.INSTANCE.channel.sendToServer((Object)packet);
    }

    public static void sendToEveryone(PenguinPacket packet) {
        PenguinNetwork.INSTANCE.channel.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendToDimension(PenguinPacket packet, RegistryKey<World> dimension) {
        PenguinNetwork.INSTANCE.channel.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)packet);
    }

    public static void sendToAllAround(PenguinPacket packet, RegistryKey<World> dimension, double x, double y, double z, int distance) {
        PenguinNetwork.INSTANCE.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)x, (double)y, (double)z, (double)distance, dimension)), (Object)packet);
    }

    public static void sendToNearby(PenguinPacket packet, World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            ((ServerWorld)world).func_72863_F().field_217237_a.func_219097_a(new ChunkPos(pos), false).forEach(player -> PenguinNetwork.sendToClient(packet, player));
        } else {
            PenguinNetwork.INSTANCE.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)), (Object)packet);
        }
    }

    public static void sendToNearby(PenguinPacket packet, Entity entity) {
        PenguinNetwork.sendToNearby(packet, entity.field_70170_p, entity.func_233580_cy_());
    }

    public static void sendToNearby(PenguinPacket packet, TileEntity tile) {
        PenguinNetwork.sendToNearby(packet, tile.func_145831_w(), tile.func_174877_v());
    }
}

