/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.network.packet;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import uk.joshiejack.penguinlib.client.PenguinTeamsClient;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.util.PenguinLoader;

@PenguinLoader.Packet(value=NetworkDirection.PLAY_TO_CLIENT)
public class SyncTeamMembersPacket
extends PenguinPacket {
    private Map<UUID, UUID> memberOf;

    public SyncTeamMembersPacket() {
    }

    public SyncTeamMembersPacket(Map<UUID, UUID> memberOf) {
        this.memberOf = memberOf;
    }

    @Override
    public void encode(PacketBuffer to) {
        to.writeByte(this.memberOf.size());
        this.memberOf.forEach((key, value) -> {
            to.func_179252_a(key);
            to.func_179252_a(value);
        });
    }

    @Override
    public void decode(PacketBuffer from) {
        this.memberOf = Maps.newHashMap();
        byte size = from.readByte();
        IntStream.range(0, size).forEach(i -> this.memberOf.put(from.func_179253_g(), from.func_179253_g()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClientPacket() {
        PenguinTeamsClient.setMembers(this.memberOf);
    }
}

