/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.note;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import uk.joshiejack.penguinlib.data.PenguinRegistries;
import uk.joshiejack.penguinlib.item.crafting.SimplePenguinRecipe;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.packet.ReadNotePacket;
import uk.joshiejack.penguinlib.network.packet.UnlockNotePacket;
import uk.joshiejack.penguinlib.note.type.NoteType;
import uk.joshiejack.penguinlib.util.helpers.minecraft.PlayerHelper;
import uk.joshiejack.penguinlib.util.icon.Icon;

public class Note
extends SimplePenguinRecipe {
    private final ITextComponent text;
    private final ITextComponent title;
    private final ResourceLocation category;
    private NoteType type;
    private boolean isHidden;
    private Icon icon;
    private boolean isLocked;

    public Note(ResourceLocation rl, ResourceLocation category, NoteType type) {
        super(PenguinRegistries.NOTE, (IRecipeSerializer)PenguinRegistries.NOTE_SERIALIZER.get(), rl, Ingredient.field_193370_a, ItemStack.field_190927_a);
        this.category = category;
        this.type = type;
        this.text = new TranslationTextComponent(Util.func_200697_a((String)"note.text", (ResourceLocation)rl));
        this.title = new TranslationTextComponent(Util.func_200697_a((String)"note.title", (ResourceLocation)rl));
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public ITextComponent getText() {
        return this.text;
    }

    public ResourceLocation getCategory() {
        return this.category;
    }

    public void setHidden() {
        this.isHidden = true;
    }

    public void setLocked() {
        this.isLocked = true;
    }

    public Note setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isUnlocked(PlayerEntity player) {
        return PlayerHelper.hasSubTag(player, "Notes", "Unlocked", this.rl.toString());
    }

    public void unlock(PlayerEntity player) {
        PlayerHelper.setSubTag(player, "Notes", "Unlocked", this.rl.toString());
        if (!player.field_70170_p.field_72995_K) {
            PenguinNetwork.sendToClient(new UnlockNotePacket(this), (ServerPlayerEntity)player);
        }
    }

    public boolean isRead(PlayerEntity player) {
        return PlayerHelper.hasSubTag(player, "Notes", "Read", this.rl.toString());
    }

    public void read(PlayerEntity player) {
        PlayerHelper.setSubTag(player, "Notes", "Read", this.rl.toString());
        if (player.field_70170_p.field_72995_K) {
            PenguinNetwork.sendToServer(new ReadNotePacket(this));
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isDefault() {
        return !this.isLocked;
    }

    public NoteType getNoteType() {
        return this.type;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<Note> {
        @Nonnull
        public Note fromJson(@Nonnull ResourceLocation rl, @Nonnull JsonObject json) {
            NoteType type = json.has("note type") ? (NoteType)NoteType.TYPES.getOrDefault((Object)JSONUtils.func_151200_h((JsonObject)json, (String)"note type"), (Object)NoteType.TEXT) : NoteType.TEXT;
            Note note = new Note(rl, new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"category")), type);
            if (json.has("hidden") && JSONUtils.func_151212_i((JsonObject)json, (String)"hidden")) {
                note.setHidden();
            }
            if (json.has("locked") && JSONUtils.func_151212_i((JsonObject)json, (String)"locked")) {
                note.setLocked();
            }
            note.setIcon(Icon.fromJson(JSONUtils.func_152754_s((JsonObject)json, (String)"icon")));
            return note;
        }

        @Nullable
        public Note fromNetwork(@Nonnull ResourceLocation rl, @Nonnull PacketBuffer pb) {
            Note note = new Note(rl, pb.func_192575_l(), (NoteType)NoteType.TYPES.getOrDefault((Object)pb.func_218666_n(), (Object)NoteType.TEXT));
            if (pb.readBoolean()) {
                note.setHidden();
            }
            if (pb.readBoolean()) {
                note.setLocked();
            }
            note.icon = Icon.fromNetwork(pb);
            return note;
        }

        public void toNetwork(@Nonnull PacketBuffer pb, @Nonnull Note note) {
            pb.func_192572_a(note.category);
            pb.func_180714_a(note.getNoteType().toString());
            pb.writeBoolean(note.isHidden);
            pb.writeBoolean(note.isLocked);
            note.getIcon().toNetwork(pb);
        }
    }
}

