/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.tile.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import uk.joshiejack.penguinlib.tile.AbstractPenguinTileEntity;
import uk.joshiejack.penguinlib.tile.inventory.PenguinInvWrapper;

public abstract class AbstractInventoryTileEntity
extends AbstractPenguinTileEntity
implements IInventory {
    protected final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(this::createHandler);
    protected final NonNullList<ItemStack> items;

    public AbstractInventoryTileEntity(TileEntityType<?> type, int size) {
        super(type);
        this.items = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    @Nonnull
    protected IItemHandler createHandler() {
        return new PenguinInvWrapper(this);
    }

    public int getSlotLimit(int slot) {
        return this.func_70297_j_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.markUpdated();
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        return ItemStackHelper.func_188382_a(this.items, (int)slot, (int)amount);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        return this.items.stream().allMatch(ItemStack::func_190926_b);
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.items, (int)slot);
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    protected void loadInventory(@Nonnull CompoundNBT nbt) {
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
    }

    public CompoundNBT saveInventory(@Nonnull CompoundNBT nbt) {
        return ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.items);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadInventory(nbt.func_74775_l("Inventory"));
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("Inventory", (INBT)this.saveInventory(new CompoundNBT()));
        return super.func_189515_b(nbt);
    }
}

