/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.tile.machine;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.block.base.AbstractDoubleBlock;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.network.packet.SetActiveStatePacket;
import uk.joshiejack.penguinlib.tile.inventory.AbstractInventoryTileEntity;

public abstract class AbstractMachineTileEntity
extends AbstractInventoryTileEntity
implements ITickableTileEntity {
    @OnlyIn(value=Dist.CLIENT)
    private Boolean shouldRender;
    private boolean active;
    private long started;
    private long passed;

    public AbstractMachineTileEntity(TileEntityType<?> type, int size) {
        super(type, size);
    }

    protected void startMachine() {
        this.active = true;
        assert (this.field_145850_b != null);
        this.started = this.field_145850_b.func_82737_E();
        if (!this.field_145850_b.field_72995_K) {
            PenguinNetwork.sendToNearby((PenguinPacket)new SetActiveStatePacket(this.field_174879_c, true), this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(ItemStack item) {
        if (this.shouldRender == null) {
            BlockState state = this.func_195044_w();
            boolean isDouble = state.func_177230_c() instanceof AbstractDoubleBlock;
            this.shouldRender = !isDouble || state.func_177229_b(AbstractDoubleBlock.HALF) == DoubleBlockHalf.LOWER;
        }
        return this.shouldRender != false && !item.func_190926_b() && !this.isActive();
    }

    public abstract void finishMachine();

    public abstract long getOperationalTime();

    @OnlyIn(value=Dist.CLIENT)
    public void setState(boolean active) {
        this.active = active;
        this.markUpdated();
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean canStart() {
        return false;
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.func_201670_d() && this.field_145850_b.func_82737_E() % 50L == 1L) {
            if (!this.isActive() && this.canStart()) {
                this.startMachine();
            }
            if (this.active && this.started != 0L) {
                this.passed += this.field_145850_b.func_82737_E() - this.started;
                this.started = this.field_145850_b.func_82737_E();
                if (this.passed >= this.getOperationalTime()) {
                    this.active = false;
                    this.passed = 0L;
                    this.started = 0L;
                    this.finishMachine();
                    PenguinNetwork.sendToNearby((PenguinPacket)new SetActiveStatePacket(this.field_174879_c, false), this);
                }
            }
        }
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.active = nbt.func_74767_n("Active");
        this.started = nbt.func_74763_f("Started");
        this.passed = nbt.func_74763_f("Passed");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74757_a("Active", this.active);
        nbt.func_74772_a("Started", this.started);
        nbt.func_74772_a("Passed", this.passed);
        return super.func_189515_b(nbt);
    }
}

