/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.util.icon;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.penguinlib.client.renderer.ShadowRenderer;
import uk.joshiejack.penguinlib.util.icon.Icon;

public abstract class AbstractCyclicIcon<T>
extends Icon {
    private static final Random random = new Random(System.currentTimeMillis());
    protected final List<T> list;
    protected T object;
    private long timer;
    private int id;

    public AbstractCyclicIcon(List<T> list) {
        this.id = random.nextInt(list.size());
        this.object = list.get(this.id);
        this.timer = System.currentTimeMillis();
        this.list = list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(Minecraft mc, MatrixStack matrix, int x, int y) {
        if (System.currentTimeMillis() - this.timer > 1000L) {
            ++this.id;
            if (this.id >= this.list.size()) {
                this.id = 0;
            }
            this.object = this.list.get(this.id);
            this.timer = System.currentTimeMillis();
        }
        this.renderCyclicIcon(mc, matrix, x, y);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void renderCyclicIcon(Minecraft var1, MatrixStack var2, int var3, int var4);

    public static abstract class ItemStack
    extends AbstractCyclicIcon<net.minecraft.item.ItemStack> {
        public ItemStack(List<net.minecraft.item.ItemStack> list) {
            super(list);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void renderCyclicIcon(Minecraft mc, MatrixStack matrix, int x, int y) {
            if (this.shadowed) {
                ShadowRenderer.enable();
            }
            mc.func_175599_af().func_175042_a((net.minecraft.item.ItemStack)this.object, x, y);
            if (this.shadowed) {
                ShadowRenderer.disable();
                this.shadowed = false;
            }
        }
    }
}

