/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.util.icon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import uk.joshiejack.penguinlib.util.icon.EntityIcon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;
import uk.joshiejack.penguinlib.util.icon.ItemListIcon;
import uk.joshiejack.penguinlib.util.icon.TagIcon;
import uk.joshiejack.penguinlib.util.icon.TextureIcon;

public abstract class Icon {
    public static final ResourceLocation DEFAULT_LOCATION = new ResourceLocation("penguinlib", "textures/gui/icons.png");
    protected boolean shadowed;

    public Icon shadowed() {
        this.shadowed = true;
        return this;
    }

    public static Icon fromJson(JsonObject json) {
        if (json.has("list")) {
            JsonArray array = json.getAsJsonArray("list");
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < array.size(); ++i) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(array.get(i).getAsString()));
                if (item == null) continue;
                items.add(new ItemStack((IItemProvider)item));
            }
            return new ItemListIcon((List<ItemStack>)items);
        }
        return json.has("item") ? new ItemIcon(new ItemStack((IItemProvider)JSONUtils.func_188180_i((JsonObject)json, (String)"item"))) : (json.has("tag") ? new TagIcon((ITag.INamedTag<Item>)ItemTags.createOptional((ResourceLocation)new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag")))) : (json.has("entity") ? new EntityIcon((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"entity"))), JSONUtils.func_151203_m((JsonObject)json, (String)"scale")) : new TextureIcon(json.has("texture") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"texture")) : DEFAULT_LOCATION, json.has("x") ? JSONUtils.func_151203_m((JsonObject)json, (String)"x") : 0, json.has("y") ? JSONUtils.func_151203_m((JsonObject)json, (String)"y") : 0)));
    }

    public abstract JsonElement toJson(JsonObject var1);

    public static Icon fromNetwork(PacketBuffer pb) {
        Type type = Type.values()[pb.readByte()];
        switch (type) {
            case ITEM: {
                return new ItemIcon(pb.func_150791_c());
            }
            case TEXTURE: {
                return new TextureIcon(pb.readBoolean() ? pb.func_192575_l() : DEFAULT_LOCATION, pb.readInt(), pb.readInt());
            }
            case ENTITY: {
                return new EntityIcon((EntityType)pb.readRegistryIdSafe(EntityType.class), pb.readByte());
            }
            case TAG: {
                return new TagIcon((ITag.INamedTag<Item>)ItemTags.createOptional((ResourceLocation)pb.func_192575_l()));
            }
            case LIST: {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                int size = pb.readInt();
                for (int i = 0; i < size; ++i) {
                    items.add(pb.func_150791_c());
                }
                return new ItemListIcon((List<ItemStack>)items);
            }
        }
        return null;
    }

    public abstract void toNetwork(PacketBuffer var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(Minecraft var1, MatrixStack var2, int var3, int var4);

    public static enum Type {
        ITEM,
        TEXTURE,
        ENTITY,
        TAG,
        LIST;

    }
}

