/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.world.teams;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import uk.joshiejack.penguinlib.events.TeamChangedOwnerEvent;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.packet.SyncTeamDataPacket;

public class PenguinTeam
implements INBTSerializable<CompoundNBT> {
    private boolean isClient;
    private CompoundNBT data;
    private Set<UUID> members;
    private UUID teamUUID;
    private UUID owner;

    public PenguinTeam(UUID uuid) {
        this.teamUUID = uuid;
        this.members = Sets.newHashSet();
        this.data = new CompoundNBT();
    }

    public void setClient() {
        this.isClient = true;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public PenguinTeam onChanged(ServerWorld world) {
        if (!this.members.contains(this.owner)) {
            this.owner = this.members.stream().findFirst().orElse(null);
            MinecraftForge.EVENT_BUS.post((Event)new TeamChangedOwnerEvent(this.teamUUID, this.owner));
        }
        this.syncToTeam(world);
        return this;
    }

    public PenguinTeam(CompoundNBT data) {
        this.deserializeNBT(data);
    }

    public Set<UUID> members() {
        return this.members;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public UUID getID() {
        return this.teamUUID;
    }

    public CompoundNBT getData() {
        return this.data;
    }

    public void syncToPlayer(ServerPlayerEntity player) {
        PenguinNetwork.sendToClient(new SyncTeamDataPacket(this.serializeNBT()), player);
    }

    public void syncToTeam(ServerWorld world) {
        PenguinNetwork.sendToTeam(new SyncTeamDataPacket(this.serializeNBT()), world, this.teamUUID);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("UUID", this.teamUUID.toString());
        compound.func_218657_a("Data", (INBT)this.data);
        ListNBT list = new ListNBT();
        this.members.forEach(uuid -> list.add((Object)StringNBT.func_229705_a_((String)uuid.toString())));
        compound.func_218657_a("Members", (INBT)list);
        if (this.owner != null) {
            compound.func_74778_a("Owner", this.owner.toString());
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.teamUUID = UUID.fromString(compound.func_74779_i("UUID"));
        this.data = compound.func_74775_l("Data");
        this.members = Sets.newHashSet();
        this.owner = compound.func_74764_b("Owner") ? UUID.fromString(compound.func_74779_i("Owner")) : null;
        ListNBT list = compound.func_150295_c("Members", 8);
        for (int i = 0; i < list.size(); ++i) {
            this.members.add(UUID.fromString(list.func_150307_f(i)));
        }
        if (this.owner == null) {
            this.owner = this.members.stream().findFirst().orElse(null);
            MinecraftForge.EVENT_BUS.post((Event)new TeamChangedOwnerEvent(this.teamUUID, this.owner));
        }
    }
}

