/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.penguinlib.world.teams;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import uk.joshiejack.penguinlib.client.PenguinTeamsClient;
import uk.joshiejack.penguinlib.events.TeamChangedEvent;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.packet.ChangeTeamPacket;
import uk.joshiejack.penguinlib.network.packet.SyncNotesPacket;
import uk.joshiejack.penguinlib.network.packet.SyncPlayerStatusesPacket;
import uk.joshiejack.penguinlib.network.packet.SyncTeamMembersPacket;
import uk.joshiejack.penguinlib.world.teams.PenguinTeam;

@Mod.EventBusSubscriber(modid="penguinlib")
public class PenguinTeams
extends WorldSavedData {
    private static final String DATA_NAME = "penguin_teams";
    private final Map<UUID, UUID> memberOf = new HashMap<UUID, UUID>();
    private final Map<UUID, PenguinTeam> teams = new HashMap<UUID, PenguinTeam>();

    public PenguinTeams() {
        super(DATA_NAME);
    }

    public static PenguinTeams get(ServerWorld world) {
        return (PenguinTeams)world.func_217481_x().func_215752_a(PenguinTeams::new, DATA_NAME);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PenguinTeams.getTeamForPlayer((PlayerEntity)player).syncToPlayer(player);
            PenguinNetwork.sendToClient(new SyncPlayerStatusesPacket(player.getPersistentData().func_74775_l("PenguinStatuses")), player);
            PenguinNetwork.sendToClient(new SyncTeamMembersPacket(PenguinTeams.get((ServerWorld)((ServerWorld)player.field_70170_p)).memberOf), player);
            PenguinNetwork.sendToClient(new SyncNotesPacket(player.getPersistentData().func_74775_l("Notes")), player);
        }
    }

    public int getMemberCount(UUID owner_id) {
        UUID team = this.memberOf.get(owner_id);
        return this.teams.get(team).members().size();
    }

    public void changeTeam(ServerWorld world, UUID player, UUID newUUID) {
        UUID oldUUID = this.memberOf.getOrDefault(player, player);
        this.memberOf.put(player, newUUID);
        PenguinTeam oldTeam = this.teams.get(oldUUID);
        if (oldTeam != null) {
            oldTeam.members().remove(player);
            oldTeam.onChanged(world);
        }
        if (!this.teams.containsKey(newUUID)) {
            this.teams.put(newUUID, new PenguinTeam(newUUID));
        }
        PenguinTeam newTeam = this.teams.get(newUUID);
        newTeam.members().add(player);
        newTeam.onChanged(world);
        MinecraftForge.EVENT_BUS.post((Event)new TeamChangedEvent((World)world, player, oldUUID, newUUID));
        PenguinNetwork.sendToEveryone(new ChangeTeamPacket(player, oldUUID, newUUID));
        this.func_76185_a();
    }

    public CompoundNBT getTeamData(UUID team) {
        return this.teams.get(team).getData();
    }

    public Collection<UUID> getTeamMembers(UUID team) {
        return this.teams.get(team).members();
    }

    public static PenguinTeam getTeamFromID(ServerWorld world, UUID team) {
        return PenguinTeams.get((ServerWorld)world).teams.get(team);
    }

    public static PenguinTeam getTeamForPlayer(ServerWorld world, UUID uuid) {
        PenguinTeams data = PenguinTeams.get(world);
        if (!data.memberOf.containsKey(uuid)) {
            data.changeTeam(world, uuid, uuid);
            data.func_76185_a();
        }
        return data.teams.get(data.memberOf.get(uuid));
    }

    public static PenguinTeam getTeamForPlayer(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return PenguinTeamsClient.getInstance();
        }
        return PenguinTeams.getTeamForPlayer((ServerWorld)player.field_70170_p, player.func_110124_au());
    }

    public UUID getTeamUUIDForPlayer(PlayerEntity player) {
        return PenguinTeams.getTeamForPlayer(player).getID();
    }

    public void func_76184_a(@Nonnull CompoundNBT nbt) {
        ListNBT data = nbt.func_150295_c("Teams", 10);
        for (int i = 0; i < data.size(); ++i) {
            CompoundNBT tag = data.func_150305_b(i);
            PenguinTeam team = new PenguinTeam(tag);
            this.teams.put(team.getID(), team);
            team.members().forEach(member -> this.memberOf.put((UUID)member, team.getID()));
        }
    }

    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        ListNBT data = new ListNBT();
        for (Map.Entry<UUID, PenguinTeam> entry : this.teams.entrySet()) {
            data.add((Object)entry.getValue().serializeNBT());
        }
        compound.func_218657_a("Teams", (INBT)data);
        return compound;
    }
}

